/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.stats;

import net.imglib2.algorithm.stats.HistogramBinMapper;
import net.imglib2.type.numeric.IntegerType;

public class IntBinMapper<T extends IntegerType<T>>
implements HistogramBinMapper<T> {
    private final T minType;
    private final T maxType;
    private final int numBins;
    private final int minVal;

    private static <R extends IntegerType<R>> R minType(R r) {
        IntegerType type = (IntegerType)r.createVariable();
        type.setReal(r.getMinValue());
        return (R)type;
    }

    private static <R extends IntegerType<R>> R maxType(R r) {
        IntegerType type = (IntegerType)r.createVariable();
        type.setReal(r.getMaxValue());
        return (R)type;
    }

    public IntBinMapper(T min, T max) {
        this.minType = min;
        this.maxType = max;
        this.numBins = max.getInteger() - min.getInteger() + 1;
        this.minVal = min.getInteger();
    }

    public IntBinMapper(T type) {
        this(IntBinMapper.minType(type), IntBinMapper.maxType(type));
    }

    @Override
    public T getMaxBin() {
        return this.maxType;
    }

    @Override
    public T getMinBin() {
        return this.minType;
    }

    @Override
    public int getNumBins() {
        return this.numBins;
    }

    @Override
    public T invMap(int i) {
        IntegerType out = (IntegerType)this.minType.createVariable();
        out.setInteger(i + this.minVal);
        return (T)out;
    }

    @Override
    public int map(T type) {
        return type.getInteger() - this.minVal;
    }
}

