/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.integral;

import net.imglib2.Cursor;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.OutputAlgorithm;
import net.imglib2.converter.Converter;
import net.imglib2.converter.TypeIdentity;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.list.ListImgFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

public class ScaleAreaAveraging2d<T extends RealType<T>, R extends RealType<R>>
implements OutputAlgorithm<Img<R>> {
    protected ImgFactory<R> imgFactory;
    protected Img<R> scaled;
    protected RandomAccessibleInterval<T> integralImg;
    protected String error;
    protected final long[] size;
    final R targetType;
    final Converter<T, R> converter;

    @Deprecated
    public ScaleAreaAveraging2d(Img<T> integralImg, R targetType, long[] size) {
        this((RandomAccessibleInterval<T>)integralImg, targetType, size, null);
        try {
            this.imgFactory = integralImg.factory().imgFactory(targetType);
        }
        catch (IncompatibleTypeException e) {
            this.imgFactory = new ListImgFactory();
        }
    }

    public ScaleAreaAveraging2d(RandomAccessibleInterval<T> integralImg, R targetType, long[] size, ImgFactory<R> imgFactory) {
        this.size = size;
        this.targetType = targetType;
        this.integralImg = integralImg;
        this.imgFactory = imgFactory;
        this.converter = targetType.getClass().isInstance(((RealType)Views.iterable(integralImg).firstElement()).createVariable()) ? new TypeIdentity() : new Converter<T, R>(){

            public void convert(T input, R output) {
                output.setReal(input.getRealDouble());
            }
        };
    }

    @Deprecated
    public ScaleAreaAveraging2d(Img<T> integralImg, R targetType, Converter<T, R> converter, long[] size) {
        this((RandomAccessibleInterval<T>)integralImg, targetType, converter, size, null);
        try {
            this.imgFactory = integralImg.factory().imgFactory(targetType);
        }
        catch (IncompatibleTypeException e) {
            this.imgFactory = new ListImgFactory();
        }
    }

    public ScaleAreaAveraging2d(RandomAccessibleInterval<T> integralImg, R targetType, Converter<T, R> converter, long[] size, ImgFactory<R> imgFactory) {
        this.size = size;
        this.targetType = targetType;
        this.integralImg = integralImg;
        this.converter = converter;
        this.imgFactory = imgFactory;
    }

    public void setOutputDimensions(long width, long height) {
        this.size[0] = width;
        this.size[1] = height;
    }

    @Override
    public boolean checkInput() {
        return true;
    }

    @Override
    public boolean process() {
        this.scaled = this.imgFactory.create(this.size, this.targetType);
        Cursor cursor = this.scaled.cursor();
        RandomAccess c2 = this.integralImg.randomAccess();
        RealType sum = (RealType)((RealType)Views.iterable(this.integralImg).firstElement()).createVariable();
        RealType area = (RealType)sum.createVariable();
        if (ScaleAreaAveraging2d.isIntegerDivision(this.integralImg, this.scaled)) {
            long stepSizeX = (this.integralImg.dimension(0) - 1L) / this.size[0];
            long stepSizeY = (this.integralImg.dimension(1) - 1L) / this.size[1];
            area.setReal((float)(stepSizeX * stepSizeY));
            while (cursor.hasNext()) {
                cursor.fwd();
                ScaleAreaAveraging2d.computeSum(cursor.getLongPosition(0) * stepSizeX, cursor.getLongPosition(1) * stepSizeY, stepSizeX, stepSizeY, c2, sum);
                sum.div((Object)area);
                this.converter.convert((Object)sum, cursor.get());
            }
        } else {
            double stepSizeX = ((double)this.integralImg.dimension(0) - 1.0) / (double)this.size[0];
            double stepSizeY = ((double)this.integralImg.dimension(1) - 1.0) / (double)this.size[1];
            while (cursor.hasNext()) {
                cursor.fwd();
                long px = cursor.getLongPosition(0);
                long py = cursor.getLongPosition(1);
                double tmp1 = (double)px * stepSizeX + 0.5;
                long startX = (long)tmp1;
                long vX = (long)(tmp1 + stepSizeX) - startX;
                double tmp2 = (double)py * stepSizeY + 0.5;
                long startY = (long)tmp2;
                long vY = (long)(tmp2 + stepSizeY) - startY;
                area.setReal((float)(vX * vY));
                ScaleAreaAveraging2d.computeSum(startX, startY, vX, vY, c2, sum);
                sum.div((Object)area);
                this.converter.convert((Object)sum, cursor.get());
            }
        }
        return true;
    }

    private static final <T extends RealType<T>> void computeSum(long startX, long startY, long vX, long vY, RandomAccess<T> c2, T sum) {
        c2.setPosition(startX, 0);
        c2.setPosition(startY, 1);
        sum.set((Type)c2.get());
        c2.move(vX, 0);
        sum.sub(c2.get());
        c2.move(vY, 1);
        sum.add(c2.get());
        c2.move(-vX, 0);
        sum.sub(c2.get());
    }

    protected static final boolean isIntegerDivision(RandomAccessibleInterval<?> integralImg, RandomAccessibleInterval<?> scaled) {
        for (int d = 0; d < scaled.numDimensions(); ++d) {
            if (0L == (integralImg.dimension(d) - 1L) % scaled.dimension(d)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getErrorMessage() {
        return this.error;
    }

    @Override
    public Img<R> getResult() {
        return this.scaled;
    }
}

