/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.integral;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import mpicbg.ij.integral.DoubleIntegralImage;
import mpicbg.ij.integral.IntegralImage;
import mpicbg.ij.integral.LongIntegralImage;
import mpicbg.ij.integral.LongRGBIntegralImage;

public final class Mean {
    private final IntegralImage integral;
    private final ImageProcessor ip;

    public Mean(ColorProcessor ip) {
        this.ip = ip;
        this.integral = new LongRGBIntegralImage(ip);
    }

    public Mean(ByteProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
    }

    public Mean(ShortProcessor ip) {
        this.ip = ip;
        this.integral = new LongIntegralImage((ImageProcessor)ip);
    }

    public Mean(FloatProcessor ip) {
        this.ip = ip;
        this.integral = new DoubleIntegralImage(ip);
    }

    public final void mean(int blockRadiusX, int blockRadiusY) {
        int w = this.ip.getWidth() - 1;
        int h = this.ip.getHeight() - 1;
        for (int y = 0; y <= h; ++y) {
            int yMin = Math.max(-1, y - blockRadiusY - 1);
            int yMax = Math.min(h, y + blockRadiusY);
            int bh = yMax - yMin;
            for (int x = 0; x <= w; ++x) {
                int xMin = Math.max(-1, x - blockRadiusX - 1);
                int xMax = Math.min(w, x + blockRadiusX);
                float scale = 1.0f / (float)(xMax - xMin) / (float)bh;
                this.ip.set(x, y, this.integral.getScaledSum(xMin, yMin, xMax, yMax, scale));
            }
        }
    }

    public final void mean(int blockRadius) {
        this.mean(blockRadius, blockRadius);
    }

    public static final Mean create(ImageProcessor ip) {
        if (FloatProcessor.class.isInstance(ip)) {
            return new Mean((FloatProcessor)ip);
        }
        if (ByteProcessor.class.isInstance(ip)) {
            return new Mean((ByteProcessor)ip);
        }
        if (ShortProcessor.class.isInstance(ip)) {
            return new Mean((ShortProcessor)ip);
        }
        if (ColorProcessor.class.isInstance(ip)) {
            return new Mean((ColorProcessor)ip);
        }
        return null;
    }
}

