/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import mpicbg.ij.clahe.Apply;
import mpicbg.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RGBApply
extends Apply<ColorProcessor> {
    protected final int[] ipPixels;

    public RGBApply(ColorProcessor ip, ByteProcessor src, ByteProcessor dst, ByteProcessor mask, int boxXMin, int boxYMin, int boxXMax, int boxYMax) throws Exception {
        super(ip, src, dst, mask, boxXMin, boxYMin, boxXMax, boxYMax);
        this.ipPixels = (int[])ip.getPixels();
    }

    @Override
    public final void apply(int cellXMin, int cellYMin, int cellXMax, int cellYMax) {
        int xMin = Math.max(this.boxXMin, cellXMin);
        int yMin = Math.max(this.boxYMin, cellYMin);
        int xMax = Math.min(this.boxXMax, cellXMax);
        int yMax = Math.min(this.boxYMax, cellYMax);
        for (int y = yMin; y < yMax; ++y) {
            int i = y * this.width + xMin;
            for (int x = xMin; x < xMax; ++x) {
                float m = (float)(this.maskPixels[i] & 0xFF) / 255.0f;
                int argb = this.ipPixels[i];
                float vr = argb >> 16 & 0xFF;
                float vg = argb >> 8 & 0xFF;
                float vb = argb & 0xFF;
                float vSrc = this.srcPixels[i] & 0xFF;
                float a = vSrc == 0.0f ? 1.0f : (float)(this.dstPixels[i] & 0xFF) / vSrc;
                float br = vr * (1.0f + m * (a - 1.0f));
                float bg = vg * (1.0f + m * (a - 1.0f));
                float bb = vb * (1.0f + m * (a - 1.0f));
                int r = Math.max(0, Math.min(255, Util.roundPos(br)));
                int g = Math.max(0, Math.min(255, Util.roundPos(bg)));
                int b = Math.max(0, Math.min(255, Util.roundPos(bb)));
                this.ipPixels[i] = r << 16 | g << 8 | b;
                ++i;
            }
        }
    }
}

