/*
 * Decompiled with CFR 0.152.
 */
package io.scif.services;

import io.scif.io.IRandomAccess;
import io.scif.io.IStreamAccess;
import io.scif.io.NIOFileHandle;
import io.scif.io.NIOService;
import io.scif.io.VirtualHandle;
import io.scif.services.LocationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugin.PluginInfo;
import org.scijava.plugin.PluginService;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultLocationService
extends AbstractService
implements LocationService {
    @Parameter
    private LogService log;
    @Parameter
    private NIOService nioService;
    @Parameter
    private PluginService pluginService;
    private HashMap<String, Object> idMap = new HashMap();
    private volatile boolean cacheListings = false;
    private volatile long cacheNanos = 3600000000000L;
    private ConcurrentHashMap<String, ListingsResult> fileListings = new ConcurrentHashMap();

    @Override
    public void reset() {
        this.cacheNanos = 3600000000000L;
        this.fileListings.clear();
        this.getIdMap().clear();
    }

    @Override
    public void cacheDirectoryListings(boolean cache) {
        this.cacheListings = cache;
    }

    @Override
    public void setCacheDirectoryTimeout(double sec) {
        this.cacheNanos = (long)(sec * 1000.0 * 1000.0 * 1000.0);
    }

    @Override
    public void clearDirectoryListingsCache() {
        this.fileListings = new ConcurrentHashMap();
    }

    @Override
    public void cleanStaleCacheEntries() {
        long t = System.nanoTime() - this.cacheNanos;
        ArrayList<String> staleKeys = new ArrayList<String>();
        for (String key : this.fileListings.keySet()) {
            if (this.fileListings.get((Object)key).time >= t) continue;
            staleKeys.add(key);
        }
        for (String key : staleKeys) {
            this.fileListings.remove(key);
        }
    }

    @Override
    public void mapId(String id, String filename) {
        if (id == null) {
            return;
        }
        if (filename == null) {
            this.getIdMap().remove(id);
        } else {
            this.getIdMap().put(id, filename);
        }
        this.log.debug((Object)("Location.mapId: " + id + " -> " + filename));
    }

    @Override
    public void mapFile(String id, IRandomAccess ira) {
        if (id == null) {
            return;
        }
        if (ira == null) {
            this.getIdMap().remove(id);
        } else {
            this.getIdMap().put(id, ira);
        }
        this.log.debug((Object)("Location.mapFile: " + id + " -> " + ira));
    }

    @Override
    public String getMappedId(String id) {
        if (this.getIdMap() == null) {
            return id;
        }
        String filename = null;
        if (id != null && this.getIdMap().get(id) instanceof String) {
            filename = (String)this.getIdMap().get(id);
        }
        return filename == null ? id : filename;
    }

    @Override
    public IRandomAccess getMappedFile(String id) {
        if (this.getIdMap() == null) {
            return null;
        }
        IRandomAccess ira = null;
        if (id != null && this.getIdMap().get(id) instanceof IRandomAccess) {
            ira = (IRandomAccess)this.getIdMap().get(id);
        }
        return ira;
    }

    @Override
    public HashMap<String, Object> getIdMap() {
        return this.idMap;
    }

    @Override
    public void setIdMap(HashMap<String, Object> map) {
        if (map == null) {
            throw new IllegalArgumentException("map cannot be null");
        }
        this.idMap = map;
    }

    @Override
    public IRandomAccess getHandle(String id) throws IOException {
        return this.getHandle(id, false);
    }

    @Override
    public IRandomAccess getHandle(String id, boolean writable) throws IOException {
        return this.getHandle(id, writable, true);
    }

    @Override
    public IRandomAccess getHandle(String id, boolean writable, boolean allowArchiveHandles) throws IOException {
        this.log.trace((Object)("getHandle(id = " + id + ", writable = " + writable + ")"));
        IRandomAccess handle = this.getMappedFile(id);
        if (handle == null) {
            this.log.trace((Object)"no handle was mapped for this ID");
            String mapId = this.getMappedId(id);
            List streamInfos = this.getContext().getPluginIndex().getPlugins(IStreamAccess.class);
            if (allowArchiveHandles) {
                for (PluginInfo info : streamInfos) {
                    handle = (IRandomAccess)this.pluginService.createInstance(info);
                    if (((IStreamAccess)handle).isConstructable(id)) {
                        ((IStreamAccess)handle).setFile(id);
                        break;
                    }
                    handle = null;
                }
            }
            try {
                if (handle == null) {
                    handle = new NIOFileHandle(this.nioService, mapId, writable ? "rw" : "r");
                }
            }
            catch (IOException e) {
                return new VirtualHandle(mapId);
            }
        }
        this.log.trace((Object)("Location.getHandle: " + id + " -> " + handle));
        return handle;
    }

    @Override
    public void checkValidId(String id) throws IOException {
        if (this.getMappedFile(id) != null) {
            return;
        }
        this.getHandle(id).close();
    }

    @Override
    public String[] getCachedListing(String key) {
        ListingsResult listingsResult = null;
        if (this.cacheListings) {
            this.cleanStaleCacheEntries();
            listingsResult = this.fileListings.get(key);
        }
        return listingsResult == null ? null : listingsResult.listing;
    }

    @Override
    public void putCachedListing(String key, String[] listing) {
        if (this.cacheListings) {
            this.fileListings.put(key, new ListingsResult(listing, System.nanoTime()));
        }
    }

    protected class ListingsResult {
        public final String[] listing;
        public final long time;

        ListingsResult(String[] listing, long time) {
            this.listing = listing;
            this.time = time;
        }
    }
}

