/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.MetadataLevel;
import io.scif.UnsupportedCompressionException;
import io.scif.config.SCIFIOConfig;
import io.scif.io.Location;
import io.scif.io.RandomAccessInputStream;
import io.scif.services.FormatService;
import io.scif.util.FormatTools;
import java.io.File;
import java.io.IOException;
import net.imagej.axis.Axes;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="NRRD")
public class NRRDFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"nrrd", "nhdr"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Unknown"};
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        @Override
        public boolean isSingleFile(String id) throws FormatException, IOException {
            return FormatTools.checkSuffix(id, "nrrd");
        }

        @Override
        public int fileGroupOption(String id) throws FormatException, IOException {
            return 0;
        }

        @Override
        public long getOptimalTileHeight(int imageIndex) {
            return ((Metadata)this.getMetadata()).get(imageIndex).getAxisLength(Axes.Y);
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = (byte[])plane.getData();
            Metadata meta = (Metadata)this.getMetadata();
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            if (meta.getDataFile() == null) {
                if (meta.getEncoding().equals("raw")) {
                    long planeSize = FormatTools.getPlaneSize(this, imageIndex);
                    this.getStream().seek(meta.getOffset() + planeIndex * planeSize);
                    this.readPlane(this.getStream(), imageIndex, planeMin, planeMax, plane);
                    return plane;
                }
                throw new UnsupportedCompressionException("Unsupported encoding: " + meta.getEncoding());
            }
            if (meta.getEncoding().equals("raw")) {
                RandomAccessInputStream s = new RandomAccessInputStream(this.getContext(), meta.getDataFile());
                s.seek(meta.getOffset() + planeIndex * FormatTools.getPlaneSize(this, imageIndex));
                this.readPlane(s, imageIndex, planeMin, planeMax, plane);
                s.close();
                return plane;
            }
            if (meta.isInitializeHelper() && meta.getDataFile() != null && meta.getHelper() != null) {
                meta.getHelper().openPlane(imageIndex, planeIndex, plane, planeMin, planeMax, config);
                return plane;
            }
            throw new FormatException("Could not find a supporting Format");
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        private FormatService formatService;

        @Override
        public String[] getImageUsedFiles(int imageIndex, boolean noPixels) {
            FormatTools.assertId(this.getSource(), true, 1);
            if (noPixels) {
                if (((Metadata)this.getMetadata()).getDataFile() == null) {
                    return null;
                }
                return new String[]{this.getSource().getFileName()};
            }
            if (((Metadata)this.getMetadata()).getDataFile() == null) {
                return new String[]{this.getSource().getFileName()};
            }
            return new String[]{this.getSource().getFileName(), ((Metadata)this.getMetadata()).getDataFile()};
        }

        @Override
        public Metadata parse(RandomAccessInputStream stream, Metadata meta) throws IOException, FormatException {
            String id = stream.getFileName();
            if (!FormatTools.checkSuffix(id, "nhdr") && !FormatTools.checkSuffix(id, "nrrd")) {
                id = id + ".nhdr";
                if (!new Location(this.getContext(), id).exists()) {
                    id = id.substring(0, id.lastIndexOf("."));
                    id = id.substring(0, id.lastIndexOf("."));
                    id = id + ".nhdr";
                }
                id = new Location(this.getContext(), id).getAbsolutePath();
            }
            stream.close();
            stream = new RandomAccessInputStream(this.getContext(), id);
            return super.parse(stream, meta);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            int numDimensions = 0;
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            iMeta.setAxisLength(Axes.X, 1L);
            iMeta.setAxisLength(Axes.Y, 1L);
            iMeta.setAxisLength(Axes.Z, 1L);
            iMeta.setAxisLength(Axes.CHANNEL, 1L);
            iMeta.setAxisLength(Axes.TIME, 1L);
            iMeta.setPlanarAxisCount(2);
            String line = this.getSource().readLine();
            while (line != null && line.length() > 0) {
                if (!line.startsWith("#") && !line.startsWith("NRRD")) {
                    String key = line.substring(0, line.indexOf(":")).trim();
                    String v = line.substring(line.indexOf(":") + 1).trim();
                    meta.getTable().put(key, v);
                    if (key.equals("type")) {
                        if (v.contains("char") || v.contains("8")) {
                            iMeta.setPixelType(1);
                        } else if (v.contains("short") || v.contains("16")) {
                            iMeta.setPixelType(3);
                        } else if (v.equals("int") || v.equals("signed int") || v.equals("int32") || v.equals("int32_t") || v.equals("uint") || v.equals("unsigned int") || v.equals("uint32") || v.equals("uint32_t")) {
                            iMeta.setPixelType(5);
                        } else if (v.equals("float")) {
                            iMeta.setPixelType(6);
                        } else {
                            if (!v.equals("double")) throw new FormatException("Unsupported data type: " + v);
                            iMeta.setPixelType(7);
                        }
                    } else if (key.equals("dimension")) {
                        numDimensions = Integer.parseInt(v);
                    } else if (key.equals("sizes")) {
                        String[] tokens = v.split(" ");
                        for (int i = 0; i < numDimensions; ++i) {
                            int size = Integer.parseInt(tokens[i]);
                            if (numDimensions >= 3 && i == 0 && size > 1 && size <= 16) {
                                iMeta.setAxisLength(Axes.CHANNEL, (long)size);
                                iMeta.setPlanarAxisCount(3);
                                continue;
                            }
                            if (i == 0 || iMeta.getPlanarAxisCount() > 2 && i == 1) {
                                iMeta.setAxisLength(Axes.X, (long)size);
                                continue;
                            }
                            if (i == 1 || iMeta.getPlanarAxisCount() > 2 && i == 2) {
                                iMeta.setAxisLength(Axes.Y, (long)size);
                                continue;
                            }
                            if (i == 2 || iMeta.getPlanarAxisCount() > 2 && i == 3) {
                                iMeta.setAxisLength(Axes.Z, (long)size);
                                continue;
                            }
                            if (i != 3 && (iMeta.getPlanarAxisCount() <= 2 || i != 4)) continue;
                            iMeta.setAxisLength(Axes.TIME, (long)size);
                        }
                    } else if (key.equals("data file") || key.equals("datafile")) {
                        meta.setDataFile(v);
                    } else if (key.equals("encoding")) {
                        meta.setEncoding(v);
                    } else if (key.equals("endian")) {
                        iMeta.setLittleEndian(v.equals("little"));
                    } else if (key.equals("spacings")) {
                        meta.setPixelSizes(v.split(" "));
                    } else if (key.equals("byte skip")) {
                        meta.setOffset(Long.parseLong(v));
                    }
                }
                if ((line = this.getSource().readLine()) == null) continue;
                line = line.trim();
            }
            if (meta.getDataFile() == null) {
                meta.setOffset(stream.getFilePointer());
            } else {
                Location f = new Location(this.getContext(), this.getSource().getFileName()).getAbsoluteFile();
                Location parent = f.getParentFile();
                if (f.exists() && parent != null) {
                    String dataFile = meta.getDataFile();
                    dataFile = dataFile.substring(dataFile.indexOf(File.separator) + 1);
                    dataFile = new Location(this.getContext(), parent, dataFile).getAbsolutePath();
                }
                meta.setInitializeHelper(!meta.getEncoding().equals("raw"));
            }
            if (!meta.isInitializeHelper()) return;
            NRRDFormat nrrd = this.formatService.getFormatFromClass(NRRDFormat.class);
            this.formatService.removeFormat(nrrd);
            Format helperFormat = this.formatService.getFormat(meta.getDataFile(), config);
            io.scif.Parser p = helperFormat.createParser();
            io.scif.Reader helper = helperFormat.createReader();
            helper.setMetadata(p.parse(meta.getDataFile(), new SCIFIOConfig().parserSetLevel(MetadataLevel.MINIMUM)));
            helper.setSource(meta.getDataFile(), config);
            meta.setHelper(helper);
            this.formatService.addFormat(nrrd);
        }

        @Override
        public boolean hasCompanionFiles() {
            return true;
        }

        @Override
        public boolean isSingleFile(String id) throws FormatException, IOException {
            return FormatTools.checkSuffix(id, "nrrd");
        }

        @Override
        public int fileGroupOption(String id) throws FormatException, IOException {
            return 0;
        }
    }

    public static class Checker
    extends AbstractChecker {
        public static final String NRRD_MAGIC_STRING = "NRRD";

        @Override
        public boolean isFormat(String name, SCIFIOConfig config) {
            if (super.isFormat(name, config)) {
                return true;
            }
            if (!config.checkerIsOpen()) {
                return false;
            }
            Location header = new Location(this.getContext(), name + ".nhdr");
            if (header.exists()) {
                return true;
            }
            if (name.contains(".")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            header = new Location(this.getContext(), name + ".nhdr");
            return header.exists();
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            int blockLen = NRRD_MAGIC_STRING.length();
            if (!FormatTools.validStream(stream, blockLen, false)) {
                return false;
            }
            return stream.readString(blockLen).startsWith(NRRD_MAGIC_STRING);
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private String dataFile;
        private String encoding;
        private long offset;
        private io.scif.Reader helper;
        private String[] pixelSizes;
        private boolean lookForCompanion = true;
        private boolean initializeHelper = false;

        public void setHelper(io.scif.Reader reader) {
            this.helper = reader;
        }

        public io.scif.Reader getHelper() {
            return this.helper;
        }

        public String getDataFile() {
            return this.dataFile;
        }

        public void setDataFile(String dataFile) {
            this.dataFile = dataFile;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public long getOffset() {
            return this.offset;
        }

        public void setOffset(long offset) {
            this.offset = offset;
        }

        public String[] getPixelSizes() {
            return this.pixelSizes;
        }

        public void setPixelSizes(String[] pixelSizes) {
            this.pixelSizes = pixelSizes;
        }

        public boolean isLookForCompanion() {
            return this.lookForCompanion;
        }

        public void setLookForCompanion(boolean lookForCompanion) {
            this.lookForCompanion = lookForCompanion;
        }

        public boolean isInitializeHelper() {
            return this.initializeHelper;
        }

        public void setInitializeHelper(boolean initializeHelper) {
            this.initializeHelper = initializeHelper;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            if (iMeta.getAxisLength(Axes.CHANNEL) > 1L) {
                iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y);
                iMeta.setPlanarAxisCount(3);
            }
            iMeta.setIndexed(false);
            iMeta.setFalseColor(false);
            iMeta.setMetadataComplete(true);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (!fileOnly) {
                this.encoding = null;
                this.dataFile = null;
                this.offset = 0L;
                this.pixelSizes = null;
                this.initializeHelper = false;
                this.helper = null;
            }
        }
    }
}

