/*
 * Decompiled with CFR 0.152.
 */
package io.scif.filters;

import io.scif.ByteArrayPlane;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.Reader;
import io.scif.config.SCIFIOConfig;
import io.scif.filters.AbstractReaderFilter;
import io.scif.filters.Filter;
import io.scif.filters.MetadataWrapper;
import io.scif.filters.PlaneSeparatorMetadata;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import io.scif.util.ImageTools;
import io.scif.util.MemoryTools;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import org.scijava.plugin.Plugin;
import org.scijava.util.ArrayUtils;

@Plugin(type=Filter.class)
public class PlaneSeparator
extends AbstractReaderFilter {
    private Plane lastPlane = null;
    private long lastPlaneIndex = -1L;
    private int lastImageIndex = -1;
    private long[] lastPlaneOffsets = null;
    private long[] lastPlaneLengths = null;

    public PlaneSeparator() {
        super((Class<? extends MetadataWrapper>)PlaneSeparatorMetadata.class);
    }

    public void separate(AxisType ... types) {
        if (this.metaCheck()) {
            ((PlaneSeparatorMetadata)this.getMetadata()).separate(types);
        }
    }

    public long getOriginalIndex(int imageIndex, long planeIndex) {
        long originalCount;
        long planeCount = this.getPlaneCount(imageIndex);
        if (planeCount == (originalCount = ((Reader)this.getParent()).getPlaneCount(imageIndex))) {
            return planeIndex;
        }
        long[] coords = FormatTools.rasterToPosition(imageIndex, planeIndex, this);
        int offset = 0;
        if (PlaneSeparatorMetadata.class.isAssignableFrom(this.getMetadata().getClass())) {
            offset = ((PlaneSeparatorMetadata)this.getMetadata()).offset();
        }
        long[] originalCoords = new long[coords.length - offset];
        long[] lengths = new long[coords.length - offset];
        for (int i = 0; i < originalCoords.length; ++i) {
            originalCoords[i] = coords[i + offset];
            lengths[i] = this.getMetadata().get(imageIndex).getAxesLengthsNonPlanar()[i + offset];
        }
        return FormatTools.positionToRaster(lengths, originalCoords);
    }

    @Override
    public void setSource(String source) throws IOException {
        this.cleanUp();
        super.setSource(source);
    }

    @Override
    public void setSource(File file) throws IOException {
        this.cleanUp();
        super.setSource(file);
    }

    @Override
    public void setSource(RandomAccessInputStream stream) throws IOException {
        this.cleanUp();
        super.setSource(stream);
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return this.getMetadata().get(imageIndex).getPlaneCount();
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, long[] offsets, long[] lengths) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, offsets, lengths, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] offsets, long[] lengths) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, offsets, lengths, new SCIFIOConfig());
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        int planarAxes = this.getMetadata().get(imageIndex).getPlanarAxisCount();
        return this.openPlane(imageIndex, planeIndex, new long[planarAxes], this.getMetadata().get(imageIndex).getAxesLengthsPlanar(), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        int planarAxes = this.getMetadata().get(imageIndex).getPlanarAxisCount();
        return this.openPlane(imageIndex, planeIndex, plane, new long[planarAxes], this.getMetadata().get(imageIndex).getAxesLengthsPlanar(), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, this.createPlane(this.getMetadata().get(imageIndex), planeMin, planeMax), planeMin, planeMax, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, long[] offsets, long[] lengths, SCIFIOConfig config) throws FormatException, IOException {
        FormatTools.checkPlaneNumber(this.getMetadata(), imageIndex, planeIndex);
        Metadata meta = this.getMetadata();
        Metadata parentMeta = this.getParentMeta();
        long source = this.getOriginalIndex(imageIndex, planeIndex);
        int splitOffset = this.metaCheck() ? ((PlaneSeparatorMetadata)meta).offset() : 0;
        boolean interleaved = parentMeta.get(imageIndex).getInterleavedAxisCount() > 0;
        PlaneSeparator planeSeparator = this;
        synchronized (planeSeparator) {
            if (!parentMeta.get(imageIndex).isIndexed()) {
                long[] completePosition = FormatTools.rasterToPosition(imageIndex, planeIndex, meta);
                long[] separatedPosition = Arrays.copyOf(completePosition, splitOffset);
                long[] separatedLengths = Arrays.copyOf(meta.get(imageIndex).getAxesLengthsNonPlanar(), splitOffset);
                int bpp = FormatTools.getBytesPerPixel(meta.get(imageIndex).getPixelType());
                if (!ByteArrayPlane.class.isAssignableFrom(plane.getClass())) {
                    plane = new ByteArrayPlane(this.getContext(), meta.get(imageIndex), offsets, lengths);
                }
                if (!this.haveCached(source, imageIndex, offsets, lengths)) {
                    int strips = 1;
                    long availableMemory = MemoryTools.totalAvailableMemory() / 16L;
                    long planeSize = meta.get(imageIndex).getPlaneSize();
                    long h = lengths[meta.get(imageIndex).getAxisIndex(Axes.Y)];
                    if (availableMemory < planeSize || planeSize > Integer.MAX_VALUE) {
                        strips = (int)Math.sqrt(h);
                    }
                    long stripHeight = h / (long)strips;
                    long lastStripHeight = stripHeight + (h - stripHeight * (long)strips);
                    byte[] strip = strips == 1 ? plane.getBytes() : new byte[(int)(stripHeight * (long)ArrayUtils.safeMultiply32((long[])Arrays.copyOf(lengths, lengths.length - 1)) * (long)bpp)];
                    this.updateLastPlaneInfo(source, imageIndex, splitOffset, offsets, lengths);
                    int parentYIndex = parentMeta.get(imageIndex).getAxisIndex(Axes.Y);
                    int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
                    for (int i = 0; i < strips; ++i) {
                        this.lastPlaneOffsets[parentYIndex] = offsets[yIndex] + (long)i * stripHeight;
                        this.lastPlaneLengths[parentYIndex] = i == strips - 1 ? lastStripHeight : stripHeight;
                        this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, (long)((int)source), this.lastPlaneOffsets, this.lastPlaneLengths, config);
                        plane.setColorTable(this.lastPlane.getColorTable());
                        if (strips != 1 && lastStripHeight != stripHeight && i == strips - 1) {
                            strip = new byte[(int)(lastStripHeight * (long)ArrayUtils.safeMultiply32((long[])Arrays.copyOf(lengths, lengths.length - 1)) * (long)bpp)];
                        }
                        ImageTools.splitChannels(this.lastPlane.getBytes(), strip, separatedPosition, separatedLengths, bpp, false, interleaved, strips == 1 ? (long)(bpp * ArrayUtils.safeMultiply32((long[])lengths)) : (long)strip.length);
                        if (strips == 1) continue;
                        System.arraycopy(strip, 0, plane.getBytes(), (int)((long)i * stripHeight * (long)ArrayUtils.safeMultiply32((long[])Arrays.copyOf(lengths, lengths.length - 1))) * bpp, strip.length);
                    }
                } else {
                    ImageTools.splitChannels(this.lastPlane.getBytes(), plane.getBytes(), separatedPosition, separatedLengths, bpp, false, interleaved, bpp * ArrayUtils.safeMultiply32((long[])lengths));
                }
                return plane;
            }
            if (!this.haveCached(source, imageIndex, offsets, lengths)) {
                this.updateLastPlaneInfo(source, imageIndex, splitOffset, offsets, lengths);
                this.lastPlane = ((Reader)this.getParent()).openPlane(imageIndex, planeIndex, plane, this.lastPlaneOffsets, this.lastPlaneLengths, config);
            }
        }
        return this.lastPlane;
    }

    @Override
    public Plane openThumbPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        int source = (int)this.getOriginalIndex(imageIndex, planeIndex);
        Plane thumb = ((Reader)this.getParent()).openThumbPlane(imageIndex, source);
        ByteArrayPlane ret = null;
        if (ByteArrayPlane.class.isAssignableFrom(thumb.getClass())) {
            ret = (ByteArrayPlane)thumb;
        } else {
            ret = new ByteArrayPlane(thumb.getContext());
            ret.populate(thumb);
        }
        int splitOffset = ((PlaneSeparatorMetadata)this.getMetadata()).offset();
        long[] completePosition = FormatTools.rasterToPosition(this.getMetadata().get(imageIndex).getAxesLengths(), planeIndex);
        long[] maxLengths = Arrays.copyOf(this.getMetadata().get(imageIndex).getAxesLengthsNonPlanar(), ((PlaneSeparatorMetadata)this.getMetadata()).offset());
        long[] pos = Arrays.copyOf(completePosition, splitOffset);
        int bpp = FormatTools.getBytesPerPixel(this.getMetadata().get(imageIndex).getPixelType());
        ret.setData(ImageTools.splitChannels(thumb.getBytes(), pos, maxLengths, bpp, false, false));
        return ret;
    }

    public double getPriority() {
        return 2.0;
    }

    private void updateLastPlaneInfo(long source, int imageIndex, int splitOffset, long[] offsets, long[] lengths) {
        Metadata meta = this.getMetadata();
        Metadata parentMeta = this.getParentMeta();
        this.lastPlaneIndex = source;
        this.lastImageIndex = imageIndex;
        this.lastPlaneOffsets = new long[offsets.length + splitOffset];
        this.lastPlaneLengths = new long[lengths.length + splitOffset];
        for (CalibratedAxis axis : parentMeta.get(imageIndex).getAxesPlanar()) {
            int parentIndex = parentMeta.get(imageIndex).getAxisIndex(axis.type());
            int currentIndex = meta.get(imageIndex).getAxisIndex(axis.type());
            if (currentIndex >= 0 && currentIndex < meta.get(imageIndex).getPlanarAxisCount()) {
                this.lastPlaneOffsets[parentIndex] = offsets[currentIndex];
                this.lastPlaneLengths[parentIndex] = lengths[currentIndex];
                continue;
            }
            if (parentMeta.get(imageIndex).getAxisIndex(axis.type()) >= parentMeta.get(imageIndex).getPlanarAxisCount()) continue;
            this.lastPlaneOffsets[parentIndex] = 0L;
            this.lastPlaneLengths[parentIndex] = parentMeta.get(imageIndex).getAxisLength(axis.type());
        }
    }

    private boolean haveCached(long source, int imageIndex, long[] offsets, long[] lengths) {
        boolean matches = source == this.lastPlaneIndex;
        boolean bl = matches = matches && imageIndex == this.lastImageIndex;
        if (this.lastPlane != null && this.lastPlaneOffsets != null && this.lastPlaneLengths != null) {
            for (int i = 0; i < offsets.length && matches; ++i) {
                matches = matches && offsets[i] == this.lastPlaneOffsets[i];
                matches = matches && offsets[i] + lengths[i] == this.lastPlaneOffsets[i] + this.lastPlaneLengths[i];
            }
        } else {
            matches = false;
        }
        return matches;
    }

    @Override
    protected void cleanUp() throws IOException {
        super.cleanUp();
        this.lastPlane = null;
        this.lastPlaneIndex = -1L;
        this.lastImageIndex = -1;
        this.lastPlaneOffsets = null;
        this.lastPlaneLengths = null;
    }
}

