/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.FilePatternBlock;
import io.scif.SCIFIO;
import io.scif.io.Location;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.scijava.Context;
import org.scijava.log.LogService;

public class FilePattern {
    private String pattern;
    private boolean valid;
    private String msg;
    private int[] startIndex;
    private int[] endIndex;
    private FilePatternBlock[] blocks;
    private String[] files;
    private boolean isRegex = false;
    private SCIFIO scifio;

    public FilePattern(Context context, Location file) {
        this(context, new SCIFIO(context).filePattern().findPattern(file));
    }

    public FilePattern(Context context, String name, String dir) {
        this(context, new SCIFIO(context).filePattern().findPattern(name, dir));
    }

    public FilePattern(Context context, String pattern) {
        int i;
        this.scifio = new SCIFIO(context);
        this.pattern = pattern;
        this.valid = false;
        if (pattern == null) {
            this.msg = "Null pattern string.";
            return;
        }
        int len = pattern.length();
        ArrayList<Integer> lt = new ArrayList<Integer>(len);
        ArrayList<Integer> gt = new ArrayList<Integer>(len);
        int left = -1;
        while ((left = pattern.indexOf("<", left + 1)) >= 0) {
            lt.add(new Integer(left));
        }
        int right = -1;
        while ((right = pattern.indexOf(">", right + 1)) >= 0) {
            gt.add(new Integer(right));
        }
        int num = lt.size();
        if (num != gt.size()) {
            this.msg = "Mismatched numerical block markers.";
            return;
        }
        this.startIndex = new int[num];
        this.endIndex = new int[num];
        for (i = 0; i < num; ++i) {
            int val = (Integer)lt.get(i);
            if (i > 0 && val < this.endIndex[i - 1]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.startIndex[i] = val;
            val = (Integer)gt.get(i);
            if (val <= this.startIndex[i]) {
                this.msg = "Bad numerical block marker order.";
                return;
            }
            this.endIndex[i] = val + 1;
        }
        this.blocks = new FilePatternBlock[num];
        for (i = 0; i < num; ++i) {
            String block = pattern.substring(this.startIndex[i], this.endIndex[i]);
            this.blocks[i] = new FilePatternBlock(block);
        }
        ArrayList<String> fileList = new ArrayList<String>();
        this.buildFiles("", num, fileList);
        this.files = fileList.toArray(new String[0]);
        if (this.files.length == 0 && new Location(this.scifio.getContext(), pattern).exists()) {
            this.files = new String[]{pattern};
        }
        this.valid = true;
    }

    public boolean isRegex() {
        return this.isRegex;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getErrorMessage() {
        return this.msg;
    }

    public String[] getFiles() {
        return this.files;
    }

    public String[][] getElements() {
        String[][] elements = new String[this.blocks.length][];
        for (int i = 0; i < elements.length; ++i) {
            elements[i] = this.blocks[i].getElements();
        }
        return elements;
    }

    public int[] getCount() {
        int[] count = new int[this.blocks.length];
        for (int i = 0; i < count.length; ++i) {
            count[i] = this.blocks[i].getElements().length;
        }
        return count;
    }

    public String getBlock(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        return this.pattern.substring(this.startIndex[i], this.endIndex[i]);
    }

    public String[] getBlocks() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getBlock(i);
        }
        return s;
    }

    public String getPrefix() {
        int dot;
        int s = this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex.length > 0 ? this.startIndex[0] : ((dot = this.pattern.lastIndexOf(".")) < s ? this.pattern.length() : dot);
        return s <= e ? this.pattern.substring(s, e) : "";
    }

    public String getSuffix() {
        return this.endIndex.length > 0 ? this.pattern.substring(this.endIndex[this.endIndex.length - 1]) : this.pattern;
    }

    public String getPrefix(int i) {
        if (i < 0 || i >= this.startIndex.length) {
            return null;
        }
        int s = i > 0 ? this.endIndex[i - 1] : this.pattern.lastIndexOf(File.separator) + 1;
        int e = this.startIndex[i];
        return s <= e ? this.pattern.substring(s, e) : null;
    }

    public String[] getPrefixes() {
        String[] s = new String[this.startIndex.length];
        for (int i = 0; i < s.length; ++i) {
            s[i] = this.getPrefix(i);
        }
        return s;
    }

    private void buildFiles(String prefix, int ndx, List<String> fileList) {
        if (this.blocks.length == 0) {
            int end;
            String dir;
            if (new Location(this.scifio.getContext(), this.pattern).exists()) {
                fileList.add(this.pattern);
                return;
            }
            this.isRegex = true;
            Object[] files = null;
            int endRegex = this.pattern.indexOf(File.separator + "\\E") + 1;
            int endNotRegex = this.pattern.lastIndexOf(File.separator) + 1;
            if (this.pattern.startsWith("\\Q") && endRegex > 0 && endRegex <= endNotRegex) {
                dir = this.pattern.substring(2, endRegex);
                end = endRegex + 2;
            } else {
                dir = this.pattern.substring(0, endNotRegex);
                end = endNotRegex;
            }
            if (dir.equals("") || !new Location(this.scifio.getContext(), dir).exists()) {
                files = this.scifio.location().getIdMap().keySet().toArray(new String[0]);
                if (files.length == 0) {
                    dir = ".";
                    files = this.getAllFiles(dir);
                }
            } else {
                files = this.getAllFiles(dir);
            }
            Arrays.sort(files);
            String basePattern = this.pattern.substring(end);
            Pattern regex = null;
            try {
                regex = Pattern.compile(basePattern);
            }
            catch (PatternSyntaxException e) {
                regex = Pattern.compile(this.pattern);
            }
            for (Object f : files) {
                Location path = new Location(this.scifio.getContext(), dir, (String)f);
                if (!regex.matcher((CharSequence)f).matches() && !regex.matcher(path.getAbsolutePath()).matches()) continue;
                if (path.exists()) {
                    fileList.add(path.getAbsolutePath());
                    continue;
                }
                fileList.add((String)f);
            }
        } else {
            int num = this.startIndex.length;
            int n1 = ndx == 0 ? 0 : this.endIndex[ndx - 1];
            int n2 = ndx == num ? this.pattern.length() : this.startIndex[ndx];
            String pre = this.pattern.substring(n1, n2);
            if (ndx == 0) {
                fileList.add(pre + prefix);
            } else {
                String[] blockElements;
                FilePatternBlock block = this.blocks[--ndx];
                for (String element : blockElements = block.getElements()) {
                    this.buildFiles(element + pre + prefix, ndx, fileList);
                }
            }
        }
    }

    private String[] getAllFiles(String dir) {
        String[] children;
        ArrayList<String> files = new ArrayList<String>();
        Location root = new Location(this.scifio.getContext(), dir);
        for (String child : children = root.list()) {
            Location file = new Location(this.scifio.getContext(), root, child);
            if (file.isDirectory()) {
                String[] grandchildren;
                for (String g : grandchildren = this.getAllFiles(file.getAbsolutePath())) {
                    files.add(g);
                }
                continue;
            }
            files.add(file.getAbsolutePath());
        }
        return files.toArray(new String[files.size()]);
    }

    public static void main(String[] args) {
        int i;
        String pat = null;
        SCIFIO scifio = new SCIFIO();
        LogService log = scifio.log();
        if (args.length > 0) {
            Location file = new Location(scifio.getContext(), args[0]);
            log.info((Object)("File = " + file.getAbsoluteFile()));
            pat = scifio.filePattern().findPattern(file);
        } else {
            String[] nameList = new String[289];
            nameList[0] = "outlier.ext";
            int count = 1;
            for (i = 1; i <= 2; ++i) {
                for (int j = 1; j <= 4; ++j) {
                    for (int k = 0; k <= 2; ++k) {
                        for (int l = 1; l <= 12; ++l) {
                            String sl = (l < 10 ? "0" : "") + l;
                            nameList[count++] = "hypothetical" + sl + k + j + "c" + i + ".ext";
                        }
                    }
                }
            }
            pat = scifio.filePattern().findPattern(nameList[1], null, nameList);
        }
        if (pat == null) {
            log.info((Object)"No pattern found.");
        } else {
            log.info((Object)("Pattern = " + pat));
            FilePattern fp = new FilePattern(scifio.getContext(), pat);
            if (fp.isValid()) {
                log.info((Object)"Pattern is valid.");
                log.info((Object)"Files:");
                String[] ids = fp.getFiles();
                for (i = 0; i < ids.length; ++i) {
                    log.info((Object)("  #" + i + ": " + ids[i]));
                }
            } else {
                log.info((Object)("Pattern is invalid: " + fp.getErrorMessage()));
            }
        }
    }

    public BigInteger[] getFirst() {
        BigInteger[] first = new BigInteger[this.blocks.length];
        for (int i = 0; i < first.length; ++i) {
            first[i] = this.blocks[i].getFirst();
        }
        return first;
    }

    public BigInteger[] getLast() {
        BigInteger[] last = new BigInteger[this.blocks.length];
        for (int i = 0; i < last.length; ++i) {
            last[i] = this.blocks[i].getLast();
        }
        return last;
    }

    public BigInteger[] getStep() {
        BigInteger[] step = new BigInteger[this.blocks.length];
        for (int i = 0; i < step.length; ++i) {
            step[i] = this.blocks[i].getStep();
        }
        return step;
    }
}

