/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractGroupable;
import io.scif.FileInfo;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.MetadataLevel;
import io.scif.TypedMetadata;
import io.scif.TypedParser;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.SCIFIOMetadataTools;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

public abstract class AbstractParser<M extends TypedMetadata>
extends AbstractGroupable
implements TypedParser<M> {
    private M metadata;

    @Override
    public M parse(String fileName) throws IOException, FormatException {
        return (M)this.parse(fileName, new SCIFIOConfig());
    }

    @Override
    public M parse(File file) throws IOException, FormatException {
        return (M)this.parse(file, new SCIFIOConfig());
    }

    @Override
    public M parse(RandomAccessInputStream stream) throws IOException, FormatException {
        return (M)this.parse(stream, new SCIFIOConfig());
    }

    @Override
    public M parse(String fileName, Metadata meta) throws IOException, FormatException {
        return (M)this.parse(fileName, meta, new SCIFIOConfig());
    }

    @Override
    public M parse(File file, Metadata meta) throws IOException, FormatException {
        return (M)this.parse(file, meta, new SCIFIOConfig());
    }

    @Override
    public M parse(RandomAccessInputStream stream, Metadata meta) throws IOException, FormatException {
        return (M)this.parse(stream, meta, new SCIFIOConfig());
    }

    public M getMetadata() {
        return this.metadata;
    }

    @Override
    public RandomAccessInputStream getSource() {
        Metadata m = this.getMetadata();
        if (m == null) {
            return null;
        }
        return m.getSource();
    }

    @Override
    public void updateSource(String source) throws IOException {
        this.metadata.setSource(new RandomAccessInputStream(this.getContext(), source));
    }

    @Override
    public String[] getUsedFiles() {
        return this.getUsedFiles(false);
    }

    @Override
    public String[] getUsedFiles(boolean noPixels) {
        Vector<String> files = new Vector<String>();
        for (int i = 0; i < this.metadata.getImageCount(); ++i) {
            String[] s = this.getImageUsedFiles(i, noPixels);
            if (s == null) continue;
            for (String file : s) {
                if (files.contains(file)) continue;
                files.add(file);
            }
        }
        return files.toArray(new String[files.size()]);
    }

    @Override
    public String[] getImageUsedFiles(int imageIndex) {
        return this.getImageUsedFiles(imageIndex, false);
    }

    @Override
    public String[] getImageUsedFiles(int imageIndex, boolean noPixels) {
        String[] stringArray;
        if (noPixels) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getMetadata().getSource().getFileName();
        }
        return stringArray;
    }

    @Override
    public FileInfo[] getAdvancedUsedFiles(boolean noPixels) {
        String[] files = this.getUsedFiles(noPixels);
        if (files == null) {
            return null;
        }
        return this.getFileInfo(files);
    }

    @Override
    public FileInfo[] getAdvancedImageUsedFiles(int imageIndex, boolean noPixels) {
        String[] files = this.getImageUsedFiles(imageIndex, noPixels);
        if (files == null) {
            return null;
        }
        return this.getFileInfo(files);
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        HashSet<MetadataLevel> supportedLevels = new HashSet<MetadataLevel>();
        supportedLevels.add(MetadataLevel.ALL);
        supportedLevels.add(MetadataLevel.NO_OVERLAYS);
        supportedLevels.add(MetadataLevel.MINIMUM);
        return supportedLevels;
    }

    @Override
    public M parse(String fileName, M meta) throws IOException, FormatException {
        return this.parse(fileName, meta, new SCIFIOConfig());
    }

    @Override
    public M parse(File file, M meta) throws IOException, FormatException {
        return this.parse(file, meta, new SCIFIOConfig());
    }

    @Override
    public M parse(RandomAccessInputStream stream, M meta) throws IOException, FormatException {
        return this.parse(stream, meta, new SCIFIOConfig());
    }

    @Override
    public M parse(String fileName, M meta, SCIFIOConfig config) throws IOException, FormatException {
        RandomAccessInputStream stream = this.getSource();
        if (stream != null) {
            if (stream.getFileName().equals(fileName)) {
                stream.seek(0L);
            } else {
                this.close();
                stream.close();
                stream = null;
            }
        }
        if (stream == null) {
            stream = new RandomAccessInputStream(this.getContext(), fileName);
        }
        return this.parse(stream, meta, config);
    }

    @Override
    public M parse(File file, M meta, SCIFIOConfig config) throws IOException, FormatException {
        return this.parse(file.getPath(), meta);
    }

    @Override
    public M parse(RandomAccessInputStream stream, M meta, SCIFIOConfig config) throws IOException, FormatException {
        RandomAccessInputStream in = this.getSource();
        if (in == null || !in.getFileName().equals(stream.getFileName())) {
            this.init(stream);
            if (config.parserIsSaveOriginalMetadata()) {
                // empty if block
            }
        }
        meta.setFiltered(config.parserIsFiltered());
        if (meta.getContext() == null) {
            this.metadata.setContext(this.getContext());
        }
        meta.setSource(stream);
        meta.setDatasetName(stream.getFileName());
        this.metadata = meta;
        this.typedParse(stream, meta, config);
        meta.populateImageMetadata();
        return meta;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.metadata != null) {
            this.metadata.close(fileOnly);
        }
    }

    protected abstract void typedParse(RandomAccessInputStream var1, M var2, SCIFIOConfig var3) throws IOException, FormatException;

    private void init(RandomAccessInputStream stream) throws IOException {
        if (this.getMetadata() != null) {
            String[] usedFiles;
            for (String fileName : usedFiles = this.getUsedFiles()) {
                if (!stream.getFileName().equals(fileName)) continue;
                return;
            }
        }
        this.close();
    }

    private FileInfo[] getFileInfo(String[] files) {
        FileInfo[] infos = new FileInfo[files.length];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = new FileInfo();
            infos[i].filename = files[i];
            infos[i].reader = this.getFormat().getReaderClass();
            infos[i].usedToInitialize = files[i].endsWith(this.getSource().getFileName());
        }
        return infos;
    }

    @Override
    public M parse(String fileName, SCIFIOConfig config) throws IOException, FormatException {
        TypedMetadata meta = (TypedMetadata)this.getFormat().createMetadata();
        return (M)this.parse(fileName, (M)meta, config);
    }

    @Override
    public M parse(File file, SCIFIOConfig config) throws IOException, FormatException {
        TypedMetadata meta = (TypedMetadata)this.getFormat().createMetadata();
        return (M)this.parse(file, (M)meta, config);
    }

    @Override
    public M parse(RandomAccessInputStream stream, SCIFIOConfig config) throws IOException, FormatException {
        TypedMetadata meta = (TypedMetadata)this.getFormat().createMetadata();
        return (M)this.parse(stream, (M)meta, config);
    }

    @Override
    public M parse(String fileName, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
        return (M)this.parse(fileName, (M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)), config);
    }

    @Override
    public M parse(File file, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
        return (M)this.parse(file, (M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)), config);
    }

    @Override
    public M parse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
        return (M)this.parse(stream, (M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)), config);
    }
}

