/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.jnr.posix;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.scijava.jython.shaded.jnr.ffi.Library;
import org.scijava.jython.shaded.jnr.ffi.LibraryOption;
import org.scijava.jython.shaded.jnr.ffi.Runtime;
import org.scijava.jython.shaded.jnr.ffi.Struct;
import org.scijava.jython.shaded.jnr.ffi.mapper.FunctionMapper;
import org.scijava.jython.shaded.jnr.posix.AixLibC;
import org.scijava.jython.shaded.jnr.posix.AixPOSIX;
import org.scijava.jython.shaded.jnr.posix.CheckedPOSIX;
import org.scijava.jython.shaded.jnr.posix.FreeBSDPOSIX;
import org.scijava.jython.shaded.jnr.posix.JavaPOSIX;
import org.scijava.jython.shaded.jnr.posix.LazyPOSIX;
import org.scijava.jython.shaded.jnr.posix.LibC;
import org.scijava.jython.shaded.jnr.posix.LibCProvider;
import org.scijava.jython.shaded.jnr.posix.LinuxLibC;
import org.scijava.jython.shaded.jnr.posix.LinuxPOSIX;
import org.scijava.jython.shaded.jnr.posix.MacOSPOSIX;
import org.scijava.jython.shaded.jnr.posix.OpenBSDPOSIX;
import org.scijava.jython.shaded.jnr.posix.POSIX;
import org.scijava.jython.shaded.jnr.posix.POSIXHandler;
import org.scijava.jython.shaded.jnr.posix.POSIXTypeMapper;
import org.scijava.jython.shaded.jnr.posix.SimpleFunctionMapper;
import org.scijava.jython.shaded.jnr.posix.SolarisLibC;
import org.scijava.jython.shaded.jnr.posix.SolarisPOSIX;
import org.scijava.jython.shaded.jnr.posix.UnixLibC;
import org.scijava.jython.shaded.jnr.posix.WindowsLibC;
import org.scijava.jython.shaded.jnr.posix.WindowsPOSIX;
import org.scijava.jython.shaded.jnr.posix.util.DefaultPOSIXHandler;
import org.scijava.jython.shaded.jnr.posix.util.Platform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class POSIXFactory {
    private static final Class<Struct> BOGUS_HACK = Struct.class;

    public static POSIX getPOSIX(POSIXHandler handler2, boolean useNativePOSIX) {
        return new LazyPOSIX(handler2, useNativePOSIX);
    }

    public static POSIX getPOSIX() {
        return POSIXFactory.getPOSIX(new DefaultPOSIXHandler(), true);
    }

    static POSIX loadPOSIX(POSIXHandler handler2, boolean useNativePOSIX) {
        POSIX posix;
        block7: {
            posix = null;
            if (useNativePOSIX) {
                try {
                    posix = POSIXFactory.loadNativePOSIX(handler2);
                    POSIX pOSIX = posix = posix != null ? new CheckedPOSIX(posix, handler2) : null;
                    if (handler2.isVerbose()) {
                        if (posix != null) {
                            System.err.println("Successfully loaded native POSIX impl.");
                        } else {
                            System.err.println("Failed to load native POSIX impl; falling back on Java impl. Unsupported OS.");
                        }
                    }
                }
                catch (Throwable t) {
                    if (!handler2.isVerbose()) break block7;
                    System.err.println("Failed to load native POSIX impl; falling back on Java impl. Stacktrace follows.");
                    t.printStackTrace();
                }
            }
        }
        if (posix == null) {
            posix = POSIXFactory.getJavaPOSIX(handler2);
        }
        return posix;
    }

    private static POSIX loadNativePOSIX(POSIXHandler handler2) {
        switch (org.scijava.jython.shaded.jnr.ffi.Platform.getNativePlatform().getOS()) {
            case DARWIN: {
                return POSIXFactory.loadMacOSPOSIX(handler2);
            }
            case LINUX: {
                return POSIXFactory.loadLinuxPOSIX(handler2);
            }
            case FREEBSD: {
                return POSIXFactory.loadFreeBSDPOSIX(handler2);
            }
            case OPENBSD: {
                return POSIXFactory.loadOpenBSDPOSIX(handler2);
            }
            case SOLARIS: {
                return POSIXFactory.loadSolarisPOSIX(handler2);
            }
            case AIX: {
                return POSIXFactory.loadAixPOSIX(handler2);
            }
            case WINDOWS: {
                return POSIXFactory.loadWindowsPOSIX(handler2);
            }
        }
        return null;
    }

    public static POSIX getJavaPOSIX(POSIXHandler handler2) {
        return new JavaPOSIX(handler2);
    }

    public static POSIX loadLinuxPOSIX(POSIXHandler handler2) {
        return new LinuxPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadMacOSPOSIX(POSIXHandler handler2) {
        return new MacOSPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadSolarisPOSIX(POSIXHandler handler2) {
        return new SolarisPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadFreeBSDPOSIX(POSIXHandler handler2) {
        return new FreeBSDPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadOpenBSDPOSIX(POSIXHandler handler2) {
        return new OpenBSDPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadWindowsPOSIX(POSIXHandler handler2) {
        return new WindowsPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    public static POSIX loadAixPOSIX(POSIXHandler handler2) {
        return new AixPOSIX(DefaultLibCProvider.INSTANCE, handler2);
    }

    private static String[] libraries() {
        switch (org.scijava.jython.shaded.jnr.ffi.Platform.getNativePlatform().getOS()) {
            case LINUX: {
                return new String[]{"libc.so.6", "crypt"};
            }
            case SOLARIS: {
                return new String[]{"socket", "nsl", "c"};
            }
            case FREEBSD: 
            case NETBSD: {
                return new String[]{"c", "crypt"};
            }
            case AIX: {
                String[] stringArray;
                if (Runtime.getSystemRuntime().addressSize() == 4) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "libc.a(shr.o)";
                } else {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = "libc.a(shr_64.o)";
                }
                return stringArray;
            }
            case WINDOWS: {
                return new String[]{"msvcrt", "kernel32"};
            }
        }
        return new String[]{"c"};
    }

    private static Class<? extends LibC> libraryInterface() {
        switch (org.scijava.jython.shaded.jnr.ffi.Platform.getNativePlatform().getOS()) {
            case LINUX: {
                return LinuxLibC.class;
            }
            case AIX: {
                return AixLibC.class;
            }
            case SOLARIS: {
                return SolarisLibC.class;
            }
            case WINDOWS: {
                return WindowsLibC.class;
            }
        }
        return UnixLibC.class;
    }

    private static FunctionMapper functionMapper() {
        switch (org.scijava.jython.shaded.jnr.ffi.Platform.getNativePlatform().getOS()) {
            case AIX: {
                return new SimpleFunctionMapper.Builder().map("stat", "stat64x").map("fstat", "fstat64x").map("lstat", "lstat64x").map("stat64", "stat64x").map("fstat64", "fstat64x").map("lstat64", "lstat64x").build();
            }
            case WINDOWS: {
                return new SimpleFunctionMapper.Builder().map("getpid", "_getpid").map("chmod", "_chmod").map("fstat", "_fstat64").map("stat", "_stat64").map("umask", "_umask").map("isatty", "_isatty").map("read", "_read").map("write", "_write").map("close", "_close").build();
            }
            case SOLARIS: {
                return Platform.IS_32_BIT ? new SimpleFunctionMapper.Builder().map("stat", "stat64").map("fstat", "fstat64").map("lstat", "lstat64").build() : null;
            }
        }
        return null;
    }

    private static Map<LibraryOption, Object> options() {
        HashMap<LibraryOption, Object> options = new HashMap<LibraryOption, Object>();
        FunctionMapper functionMapper = POSIXFactory.functionMapper();
        if (functionMapper != null) {
            options.put(LibraryOption.FunctionMapper, functionMapper);
        }
        options.put(LibraryOption.TypeMapper, POSIXTypeMapper.INSTANCE);
        options.put(LibraryOption.LoadNow, Boolean.TRUE);
        return Collections.unmodifiableMap(options);
    }

    static /* synthetic */ Class access$000() {
        return POSIXFactory.libraryInterface();
    }

    static /* synthetic */ Map access$100() {
        return POSIXFactory.options();
    }

    static /* synthetic */ String[] access$200() {
        return POSIXFactory.libraries();
    }

    private static final class DefaultLibCProvider
    implements LibCProvider {
        public static final LibCProvider INSTANCE = new DefaultLibCProvider();

        private DefaultLibCProvider() {
        }

        public final LibC getLibC() {
            return SingletonHolder.libc;
        }

        private static final class SingletonHolder {
            public static LibC libc = (LibC)Library.loadLibrary(POSIXFactory.access$000(), POSIXFactory.access$100(), POSIXFactory.access$200());

            private SingletonHolder() {
            }
        }
    }
}

