/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.plugins.commands.imglib;

import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.ImgPlus;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.LanczosInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NearestNeighborInterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import org.scijava.ItemIO;
import org.scijava.command.Command;
import org.scijava.command.ContextCommand;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, initializer="init", headless=true, menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Transform", mnemonic=116), @Menu(label="Rotate...", mnemonic=114)}, attrs={@Attr(name="no-legacy")})
public class RotateImageXY<T extends RealType<T>>
extends ContextCommand {
    private static final String LANCZOS = "Lanczos";
    private static final String LINEAR = "Linear";
    private static final String NEAREST_NEIGHBOR = "Nearest Neighbor";
    private static final String DEGREES = "Degrees";
    private static final String RADIANS = "Radians";
    @Parameter(type=ItemIO.BOTH)
    private Dataset dataset;
    @Parameter(label="Angle")
    private double angle;
    @Parameter(label="Unit", choices={"Degrees", "Radians"})
    private String angleUnit = "Degrees";
    @Parameter(label="Interpolation", choices={"Linear", "Nearest Neighbor", "Lanczos"}, persist=false)
    private String method = "Linear";
    @Parameter
    private DatasetService datasetService;

    public void setDataset(Dataset ds) {
        this.dataset = ds;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setUnit(String unit) {
        if (unit.equals(DEGREES)) {
            this.angleUnit = unit;
        } else if (unit.equals(RADIANS)) {
            this.angleUnit = unit;
        } else {
            throw new IllegalArgumentException("Unknown angle unit: " + unit);
        }
    }

    public String getUnit() {
        return this.angleUnit;
    }

    public void setInterpolationMethod(String str) {
        if (str.equals(LINEAR)) {
            this.method = LINEAR;
        } else if (str.equals(NEAREST_NEIGHBOR)) {
            this.method = NEAREST_NEIGHBOR;
        } else if (str.equals(LANCZOS)) {
            this.method = LANCZOS;
        } else {
            throw new IllegalArgumentException("Unknown interpolation method: " + str);
        }
    }

    public String getInterpolationMethod() {
        return this.method;
    }

    public void run() {
        double ang = this.radians(this.angle);
        this.resampleData(this.dataset, ang);
    }

    private double radians(double angle) {
        if (this.angleUnit.equals(RADIANS)) {
            return angle;
        }
        return angle * 2.0 * Math.PI / 360.0;
    }

    private void resampleData(Dataset ds, double angleInRadians) {
        ImgPlus dest = ds.getImgPlus();
        ImgPlus src = dest.copy();
        RealType zero = (RealType)((RealType)src.firstElement()).createVariable();
        zero.setZero();
        InterpolatorFactory<T, RandomAccessible<T>> ifac = this.getInterpolator();
        RealRandomAccess inter = ifac.create((Object)Views.extend((RandomAccessibleInterval)src, (OutOfBoundsFactory)new OutOfBoundsConstantValueFactory((Type)zero)));
        Cursor c2 = Views.iterable((RandomAccessibleInterval)dest).localizingCursor();
        double cos = Math.cos(angleInRadians);
        double sin = Math.sin(angleInRadians);
        double[] center = new double[dest.numDimensions()];
        center[0] = (double)dest.dimension(0) / 2.0 - 0.5;
        center[1] = (double)dest.dimension(1) / 2.0 - 0.5;
        double[] delta = new double[dest.numDimensions()];
        long[] d = new long[dest.numDimensions()];
        while (c2.hasNext()) {
            c2.fwd();
            c2.localize(d);
            this.findDeltas(center, d, cos, sin, delta);
            inter.setPosition(center[0] + delta[0], 0);
            inter.setPosition(center[1] + delta[1], 1);
            for (int i = 2; i < d.length; ++i) {
                inter.setPosition(d[i], i);
            }
            ((RealType)c2.get()).set((Type)inter.get());
        }
        ds.update();
    }

    private void findDeltas(double[] ctr, long[] pt, double cos, double sin, double[] delta) {
        double dx = (double)pt[0] - ctr[0];
        double dy = (double)pt[1] - ctr[1];
        double xPrime = dx * cos - dy * sin;
        double yPrime = dx * sin + dy * cos;
        delta[0] = xPrime;
        delta[1] = yPrime;
    }

    private InterpolatorFactory<T, RandomAccessible<T>> getInterpolator() {
        if (this.method.equals(LINEAR)) {
            return new NLinearInterpolatorFactory();
        }
        if (this.method.equals(NEAREST_NEIGHBOR)) {
            return new NearestNeighborInterpolatorFactory();
        }
        if (this.method.equals(LANCZOS)) {
            return new LanczosInterpolatorFactory();
        }
        throw new IllegalArgumentException("unknown interpolation method: " + this.method);
    }
}

