/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.module;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.scijava.Validated;
import org.scijava.ValidityProblem;
import org.scijava.module.MethodCallException;

public class MethodRef
implements Validated {
    private final Method method;
    private final String label;
    private final List<ValidityProblem> problems = new ArrayList<ValidityProblem>();

    public MethodRef(Class<?> clazz, String methodName, Class<?> ... params) {
        this.method = this.findMethod(clazz, methodName, params);
        this.label = this.method == null ? null : clazz.getName() + "#" + this.method.getName();
    }

    public void execute(Object obj, Object ... args) throws MethodCallException {
        if (this.method == null) {
            return;
        }
        try {
            this.method.invoke(obj, args);
        }
        catch (Exception exc) {
            throw new MethodCallException("Error executing method: " + this.label, exc);
        }
    }

    private Method findMethod(Class<?> clazz, String methodName, Class<?> ... params) {
        if (clazz == null) {
            return null;
        }
        if (methodName == null || methodName.isEmpty()) {
            return null;
        }
        for (Class<?> c = clazz; c != null; c = c.getSuperclass()) {
            try {
                Method m = c.getDeclaredMethod(methodName, params);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException m) {
                continue;
            }
            catch (Exception e) {
                break;
            }
        }
        String problem = "Method not found: " + clazz.getName() + "#" + methodName;
        this.problems.add(new ValidityProblem(problem));
        return null;
    }

    @Override
    public boolean isValid() {
        return this.problems.isEmpty();
    }

    @Override
    public List<ValidityProblem> getProblems() {
        return Collections.unmodifiableList(this.problems);
    }
}

