/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.scijava.io.AbstractDataHandle;
import org.scijava.io.DataHandle;
import org.scijava.io.FileLocation;
import org.scijava.plugin.Plugin;

@Plugin(type=DataHandle.class)
public class FileHandle
extends AbstractDataHandle<FileLocation> {
    private RandomAccessFile raf;
    private String mode = "rw";

    public RandomAccessFile getRandomAccessFile() throws IOException {
        return this.raf();
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        if (this.raf != null) {
            throw new IllegalStateException("File already initialized");
        }
        this.mode = mode;
    }

    @Override
    public long offset() throws IOException {
        return this.raf().getFilePointer();
    }

    @Override
    public long length() throws IOException {
        return this.raf().length();
    }

    @Override
    public int read() throws IOException {
        return this.raf().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf().read(b, off, len);
    }

    @Override
    public void seek(long pos) throws IOException {
        this.raf().seek(pos);
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.raf().readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.raf().readByte();
    }

    @Override
    public char readChar() throws IOException {
        return this.raf().readChar();
    }

    @Override
    public double readDouble() throws IOException {
        return this.raf().readDouble();
    }

    @Override
    public float readFloat() throws IOException {
        return this.raf().readFloat();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.raf().readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.raf().readFully(b, off, len);
    }

    @Override
    public int readInt() throws IOException {
        return this.raf().readInt();
    }

    @Override
    public String readLine() throws IOException {
        return this.raf().readLine();
    }

    @Override
    public long readLong() throws IOException {
        return this.raf().readLong();
    }

    @Override
    public short readShort() throws IOException {
        return this.raf().readShort();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.raf().readUnsignedByte();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.raf().readUnsignedShort();
    }

    @Override
    public String readUTF() throws IOException {
        return this.raf().readUTF();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.raf().skipBytes(n);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.raf().write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.raf().write(b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.raf().write(b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.raf().writeBoolean(v);
    }

    @Override
    public void writeByte(int v) throws IOException {
        this.raf().writeByte(v);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        this.raf().writeBytes(s);
    }

    @Override
    public void writeChar(int v) throws IOException {
        this.raf().writeChar(v);
    }

    @Override
    public void writeChars(String s) throws IOException {
        this.raf().writeChars(s);
    }

    @Override
    public void writeDouble(double v) throws IOException {
        this.raf().writeDouble(v);
    }

    @Override
    public void writeFloat(float v) throws IOException {
        this.raf().writeFloat(v);
    }

    @Override
    public void writeInt(int v) throws IOException {
        this.raf().writeInt(v);
    }

    @Override
    public void writeLong(long v) throws IOException {
        this.raf().writeLong(v);
    }

    @Override
    public void writeShort(int v) throws IOException {
        this.raf().writeShort(v);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        this.raf().writeUTF(str);
    }

    @Override
    public void close() throws IOException {
        this.raf().close();
    }

    @Override
    public Class<FileLocation> getType() {
        return FileLocation.class;
    }

    private RandomAccessFile raf() throws IOException {
        if (this.raf == null) {
            this.initRAF();
        }
        return this.raf;
    }

    private synchronized void initRAF() throws IOException {
        this.raf = new RandomAccessFile(((FileLocation)this.get()).getFile(), this.getMode());
    }
}

