/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.util;

import net.imglib2.AbstractWrappedInterval;
import net.imglib2.Cursor;
import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.type.BooleanType;

public class RandomAccessibleRegionCursor<T extends BooleanType<T>>
extends AbstractWrappedInterval<RandomAccessibleInterval<T>>
implements Cursor<Void> {
    private final RandomAccess<T> randomAccess;
    private final int n;
    private long index;
    private final long maxIndex;
    private long lineIndex;
    private final long maxLineIndex;

    public RandomAccessibleRegionCursor(RandomAccessibleInterval<T> interval, long size) {
        super(interval);
        this.randomAccess = interval.randomAccess();
        this.n = this.numDimensions();
        this.maxLineIndex = this.dimension(0) - 1L;
        this.maxIndex = size;
        this.reset();
    }

    protected RandomAccessibleRegionCursor(RandomAccessibleRegionCursor<T> cursor) {
        super((Interval)cursor.sourceInterval);
        this.randomAccess = cursor.randomAccess.copyRandomAccess();
        this.n = cursor.n;
        this.lineIndex = cursor.lineIndex;
        this.maxIndex = cursor.maxIndex;
        this.maxLineIndex = cursor.maxLineIndex;
    }

    public Void get() {
        return null;
    }

    public void jumpFwd(long steps) {
        for (long i = 0L; i < steps; ++i) {
            this.fwd();
        }
    }

    public void fwd() {
        do {
            this.randomAccess.fwd(0);
            if (++this.lineIndex <= this.maxLineIndex) continue;
            this.nextLine();
        } while (!((BooleanType)this.randomAccess.get()).get());
        ++this.index;
    }

    private void nextLine() {
        this.lineIndex = 0L;
        this.randomAccess.setPosition(this.min(0), 0);
        for (int d = 1; d < this.n; ++d) {
            this.randomAccess.fwd(d);
            if (this.randomAccess.getLongPosition(d) <= this.max(d)) break;
            this.randomAccess.setPosition(this.min(d), d);
        }
    }

    public void reset() {
        this.index = 0L;
        this.lineIndex = -1L;
        this.min((Positionable)this.randomAccess);
        this.randomAccess.bck(0);
    }

    public boolean hasNext() {
        return this.index < this.maxIndex;
    }

    public Void next() {
        this.fwd();
        return this.get();
    }

    public void remove() {
    }

    public RandomAccessibleRegionCursor<T> copy() {
        return new RandomAccessibleRegionCursor<T>(this);
    }

    public RandomAccessibleRegionCursor<T> copyCursor() {
        return this.copy();
    }

    public void localize(float[] position) {
        this.randomAccess.localize(position);
    }

    public void localize(double[] position) {
        this.randomAccess.localize(position);
    }

    public float getFloatPosition(int d) {
        return this.randomAccess.getFloatPosition(d);
    }

    public double getDoublePosition(int d) {
        return this.randomAccess.getDoublePosition(d);
    }

    public void localize(int[] position) {
        this.randomAccess.localize(position);
    }

    public void localize(long[] position) {
        this.randomAccess.localize(position);
    }

    public int getIntPosition(int d) {
        return this.randomAccess.getIntPosition(d);
    }

    public long getLongPosition(int d) {
        return this.randomAccess.getLongPosition(d);
    }
}

