/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.roi.geometric;

import java.util.List;
import net.imglib2.AbstractRealInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessibleRealInterval;
import net.imglib2.roi.geometric.RasterizedPolygon;
import net.imglib2.roi.util.Contains;
import net.imglib2.roi.util.ContainsRealRandomAccess;
import net.imglib2.roi.util.IterableRandomAccessibleRegion;
import net.imglib2.roi.util.ROIUtils;
import net.imglib2.type.logic.BoolType;
import net.imglib2.util.Intervals;

public class Polygon
extends AbstractRealInterval
implements RealRandomAccessibleRealInterval<BoolType>,
Contains<RealLocalizable> {
    private final List<? extends RealLocalizable> vertices;

    public Polygon(List<? extends RealLocalizable> vertices) {
        super(ROIUtils.getBoundsReal(vertices));
        assert (this.n == 2);
        this.vertices = vertices;
    }

    @Override
    public boolean contains(RealLocalizable localizable) {
        if (Intervals.contains((RealInterval)this, (RealLocalizable)localizable)) {
            boolean result = false;
            int i = 0;
            int j = this.vertices.size() - 1;
            while (i < this.vertices.size()) {
                double j1 = this.vertices.get(j).getDoublePosition(1);
                double j0 = this.vertices.get(j).getDoublePosition(0);
                double i0 = this.vertices.get(i).getDoublePosition(0);
                double i1 = this.vertices.get(i).getDoublePosition(1);
                double l1 = localizable.getDoublePosition(1);
                double l0 = localizable.getDoublePosition(0);
                if (i1 > l1 != j1 > l1 && l0 < (j0 - i0) * (l1 - i1) / (j1 - i1) + i0) {
                    result = !result;
                }
                j = i++;
            }
            return result;
        }
        return false;
    }

    public RealRandomAccess<BoolType> realRandomAccess() {
        return new ContainsRealRandomAccess(this);
    }

    public RealRandomAccess<BoolType> realRandomAccess(RealInterval interval) {
        return this.realRandomAccess();
    }

    public List<? extends RealLocalizable> getVertices() {
        return this.vertices;
    }

    public IterableRandomAccessibleRegion<BoolType> rasterize() {
        return new RasterizedPolygon(this);
    }

    public Polygon copyContains() {
        return this;
    }
}

