/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jvm.serialization;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.twosigma.beaker.jvm.object.OutputContainer;
import com.twosigma.beaker.jvm.object.OutputContainerLayoutManager;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.util.ArrayList;
import java.util.List;

public class OutputContainerDeserializer
implements ObjectDeserializer {
    protected final BeakerObjectConverter parent;

    public OutputContainerDeserializer(BeakerObjectConverter p) {
        this.parent = p;
        this.addKnownBeakerType();
    }

    protected void addKnownBeakerType() {
        this.parent.addKnownBeakerType("OutputContainer");
    }

    @Override
    public Object deserialize(JsonNode n, ObjectMapper mapper) {
        OutputContainer o = null;
        try {
            JsonNode nn;
            ArrayList<Object> items = null;
            ArrayList<String> labels = null;
            if (n.has("items") && (nn = n.get("items")).isArray()) {
                items = new ArrayList<Object>();
                for (JsonNode no : nn) {
                    items.add(this.parent.deserialize(no, mapper));
                }
            }
            if (n.has("labels") && (nn = n.get("labels")).isArray()) {
                labels = new ArrayList<String>();
                for (JsonNode no : nn) {
                    labels.add(no.asText());
                }
            }
            o = this.createOutputContainer(items, labels);
            if (n.has("layout")) {
                Object layout = this.parent.deserialize(n.get("layout"), mapper);
                o.setLayoutManager((OutputContainerLayoutManager)layout);
            }
        }
        catch (Exception e) {
            OutputContainer.LOGGER.error("exception deserializing OutputContainer ", (Throwable)e);
        }
        return o;
    }

    protected OutputContainer createOutputContainer(List<Object> items, List<String> labels) {
        return new OutputContainer(items, labels);
    }

    @Override
    public boolean canBeUsed(JsonNode n) {
        return n.has("type") && n.get("type").asText().equals("OutputContainer");
    }
}

