/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.msg;

import com.twosigma.beaker.SerializeToString;
import com.twosigma.beaker.jupyter.SocketEnum;
import com.twosigma.beaker.jupyter.Utils;
import com.twosigma.beaker.jupyter.msg.JupyterMessages;
import com.twosigma.beaker.jupyter.msg.MessageHolder;
import com.twosigma.beaker.jvm.object.ConsoleOutput;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.beaker.mimetype.MIMEContainer;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.message.Header;
import com.twosigma.jupyter.message.Message;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageCreator {
    public static final String EXECUTION_STATE = "execution_state";
    public static final String BUSY = "busy";
    public static final String IDLE = "idle";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String NULL_RESULT = "null";
    public static Logger logger = LoggerFactory.getLogger(MessageCreator.class);
    protected KernelFunctionality kernel;

    public MessageCreator(KernelFunctionality kernel) {
        this.kernel = kernel;
    }

    private Message initMessage(JupyterMessages type, Message message) {
        Message reply = new Message();
        reply.setParentHeader(message.getHeader());
        reply.setIdentities(message.getIdentities());
        reply.setHeader(new Header(type, message.getHeader().getSession()));
        return reply;
    }

    public Message buildMessage(Message message, String mime, String code, int executionCount) {
        Message reply = this.initMessage(JupyterMessages.EXECUTE_RESULT, message);
        reply.setContent(new HashMap<String, Serializable>());
        reply.getContent().put("execution_count", Integer.valueOf(executionCount));
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put(mime, code);
        reply.getContent().put("data", map3);
        reply.getContent().put("metadata", new HashMap());
        return reply;
    }

    public Message buildClearOutput(Message message, boolean wait) {
        Message reply = this.initMessage(JupyterMessages.CLEAR_OUTPUT, message);
        reply.setContent(new HashMap<String, Serializable>());
        reply.getContent().put("wait", Boolean.valueOf(wait));
        reply.getContent().put("metadata", new HashMap());
        return reply;
    }

    public Message buildDisplayData(Message message, MIMEContainer value) {
        Message reply = this.initMessage(JupyterMessages.DISPLAY_DATA, message);
        reply.setContent(new HashMap<String, Serializable>());
        reply.getContent().put("metadata", new HashMap());
        HashMap<String, String> map3 = new HashMap<String, String>();
        map3.put(value.getMime().getMime(), value.getCode());
        reply.getContent().put("data", map3);
        return reply;
    }

    private Message buildReply(Message message, SimpleEvaluationObject seo) {
        Message reply = this.buildReplyWithoutStatus(message, seo.getExecutionCount());
        if (SimpleEvaluationObject.EvaluationStatus.FINISHED == seo.getStatus()) {
            reply.getMetadata().put("status", (Serializable)((Object)"ok"));
            reply.getContent().put("status", (Serializable)((Object)"ok"));
            reply.getContent().put("user_expressions", new HashMap());
        } else if (SimpleEvaluationObject.EvaluationStatus.ERROR == seo.getStatus()) {
            reply.getMetadata().put("status", (Serializable)((Object)"error"));
            reply.getContent().put("status", (Serializable)((Object)"error"));
        }
        return reply;
    }

    private Message buildReplyWithoutStatus(Message message, int executionCount) {
        Message reply = this.initMessage(JupyterMessages.EXECUTE_REPLY, message);
        Hashtable<String, Serializable> map6 = new Hashtable<String, Serializable>(3);
        map6.put("dependencies_met", Boolean.valueOf(true));
        map6.put("engine", (Serializable)((Object)this.kernel.getSessionId()));
        map6.put("started", (Serializable)((Object)Utils.timestamp()));
        reply.setMetadata(map6);
        Hashtable<String, Serializable> map7 = new Hashtable<String, Serializable>(1);
        map7.put("execution_count", Integer.valueOf(executionCount));
        reply.setContent(map7);
        return reply;
    }

    public Message buildOutputMessage(Message message, String text, boolean hasError) {
        Message reply = this.initMessage(JupyterMessages.STREAM, message);
        reply.setContent(new HashMap<String, Serializable>());
        reply.getContent().put("name", (Serializable)((Object)(hasError ? "stderr" : "stdout")));
        reply.getContent().put("text", (Serializable)((Object)text));
        logger.debug("Console output:", (Object)("Error: " + hasError), (Object)text);
        return reply;
    }

    public synchronized void createMagicMessage(Message reply, int executionCount, Message message) {
        this.kernel.publish(reply);
        this.kernel.publish(this.buildReplyWithoutStatus(message, executionCount));
    }

    public synchronized List<MessageHolder> createMessage(SimpleEvaluationObject seo) {
        logger.debug("Creating message response message from: " + seo);
        Message message = seo.getJupyterMessage();
        ArrayList<MessageHolder> ret = new ArrayList<MessageHolder>();
        if (this.isConsoleOutputMessage(seo)) {
            ret.addAll(this.createConsoleResult(seo, message));
        } else if (this.isSupportedStatus(seo.getStatus())) {
            ret.addAll(this.createResultForSupportedStatus(seo, message));
        } else {
            logger.debug("Unhandled status of SimpleEvaluationObject : " + (Object)((Object)seo.getStatus()));
        }
        return ret;
    }

    private List<MessageHolder> createResultForSupportedStatus(SimpleEvaluationObject seo, Message message) {
        ArrayList<MessageHolder> ret = new ArrayList<MessageHolder>();
        if (SimpleEvaluationObject.EvaluationStatus.FINISHED == seo.getStatus() && this.showResult(seo)) {
            MessageHolder mh = this.createFinishResult(seo, message);
            if (mh != null) {
                ret.add(mh);
            }
        } else if (SimpleEvaluationObject.EvaluationStatus.ERROR == seo.getStatus()) {
            ret.add(this.createErrorResult(seo, message));
        }
        ret.add(new MessageHolder(SocketEnum.IOPUB_SOCKET, this.createIdleMessage(message)));
        ret.add(new MessageHolder(SocketEnum.SHELL_SOCKET, this.buildReply(message, seo)));
        return ret;
    }

    private boolean isSupportedStatus(SimpleEvaluationObject.EvaluationStatus status) {
        return SimpleEvaluationObject.EvaluationStatus.FINISHED == status || SimpleEvaluationObject.EvaluationStatus.ERROR == status;
    }

    private boolean isConsoleOutputMessage(SimpleEvaluationObject seo) {
        return seo.getConsoleOutput() != null && !seo.getConsoleOutput().isEmpty();
    }

    private List<MessageHolder> createConsoleResult(SimpleEvaluationObject seo, Message message) {
        ArrayList<MessageHolder> result = new ArrayList<MessageHolder>();
        while (!seo.getConsoleOutput().isEmpty()) {
            ConsoleOutput co = seo.getConsoleOutput().poll();
            result.add(new MessageHolder(SocketEnum.IOPUB_SOCKET, this.buildOutputMessage(message, co.getText(), co.isError())));
        }
        return result;
    }

    private MessageHolder createErrorResult(SimpleEvaluationObject seo, Message message) {
        String[] temp;
        String[] errorMessage = seo.getPayload().toString().split("\n");
        if ((errorMessage = this.clearText(errorMessage)) != null && errorMessage.length > 0) {
            logger.info("Execution result ERROR: " + errorMessage[0]);
        }
        Message reply = this.initMessage(JupyterMessages.ERROR, message);
        Hashtable<String, Serializable> map4 = new Hashtable<String, Serializable>(2);
        String ename = "";
        String evalue = "";
        if (errorMessage != null && errorMessage[0] != null && !errorMessage[0].isEmpty() && (temp = errorMessage[0].split(":")) != null) {
            if (temp.length == 1) {
                ename = temp[0];
                evalue = temp[0];
            } else if (temp.length > 1) {
                ename = temp[0];
                evalue = temp[1];
            }
        }
        map4.put("ename", (Serializable)((Object)ename));
        map4.put("evalue", (Serializable)((Object)evalue));
        map4.put("traceback", (Serializable)this.markRed(errorMessage));
        map4.put("text", (Serializable)((Object)((String)seo.getPayload())));
        reply.setContent(map4);
        return new MessageHolder(SocketEnum.IOPUB_SOCKET, reply);
    }

    private String[] clearText(String[] input) {
        ArrayList<String> ret = new ArrayList<String>();
        if (input != null) {
            for (String line : input) {
                if (line == null) continue;
                if (line.endsWith("\r")) {
                    ret.add(line.substring(0, line.length() - 1));
                    continue;
                }
                ret.add(line);
            }
        }
        return (String[])ret.stream().toArray(String[]::new);
    }

    private String[] markRed(String[] input) {
        ArrayList<String> ret = new ArrayList<String>();
        if (input != null) {
            for (String line : input) {
                if (line == null) continue;
                ret.add("\u001b[0;31m" + line + "");
            }
        }
        return (String[])ret.stream().toArray(String[]::new);
    }

    private MessageHolder createFinishResult(SimpleEvaluationObject seo, Message message) {
        MessageHolder ret = null;
        MIMEContainer resultString = SerializeToString.doit(seo.getPayload());
        if (!MIMEContainer.MIME.HIDDEN.equals((Object)resultString.getMime())) {
            ret = new MessageHolder(SocketEnum.IOPUB_SOCKET, this.buildMessage(message, resultString.getMime().getMime(), resultString.getCode() + this.outputdataResult(seo.getOutputdata()), seo.getExecutionCount()));
        }
        return ret;
    }

    private String outputdataResult(List<Object> outputdata) {
        String result = "";
        for (Object o : outputdata) {
            if (o instanceof SimpleEvaluationObject.EvaluationStdOutput) {
                result = result + "\n" + ((SimpleEvaluationObject.EvaluationStdOutput)o).payload;
                continue;
            }
            if (!(o instanceof SimpleEvaluationObject.EvaluationStdError)) continue;
            result = result + "\n" + ((SimpleEvaluationObject.EvaluationStdError)o).payload;
        }
        return result;
    }

    private boolean showResult(SimpleEvaluationObject seo) {
        boolean ret = true;
        if (seo != null && seo.getPayload() != null && seo.getPayload() instanceof MIMEContainer) {
            MIMEContainer input = (MIMEContainer)seo.getPayload();
            ret = !MIMEContainer.MIME.HIDDEN.equals((Object)input.getMime());
        } else if (seo != null && !seo.getOutputdata().isEmpty()) {
            ret = true;
        }
        return ret;
    }

    public Message createBusyMessage(Message parentMessage) {
        return this.getExecutionStateMessage(parentMessage, BUSY);
    }

    public Message createIdleMessage(Message parentMessage) {
        return this.getExecutionStateMessage(parentMessage, IDLE);
    }

    private Message getExecutionStateMessage(Message parentMessage, String state) {
        HashMap<String, Serializable> map1 = new HashMap<String, Serializable>(1);
        map1.put(EXECUTION_STATE, (Serializable)((Object)state));
        Message reply = this.initMessage(JupyterMessages.STATUS, parentMessage);
        reply.setContent(map1);
        return reply;
    }
}

