/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.jupyter.comm;

import com.twosigma.beaker.jupyter.comm.BaseHandler;
import com.twosigma.jupyter.KernelFunctionality;
import com.twosigma.jupyter.message.Message;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KernelControlGetDefaultShellHandler
extends BaseHandler<Boolean> {
    public static final String GET_DEFAULT_SHELL = "get_default_shell";
    public static final String KERNEL_CONTROL_RESPONSE = "kernel_control_response";
    private static final Logger logger = LoggerFactory.getLogger(KernelControlGetDefaultShellHandler.class);

    public KernelControlGetDefaultShellHandler(KernelFunctionality kernel) {
        super(kernel);
    }

    @Override
    public void handle(Message message) {
        logger.debug("Handing comm message content");
        Boolean ok = (Boolean)this.getValueFromData(message, this.getHandlerCommand());
        if (ok != null && ok.booleanValue()) {
            HashMap<String, String[]> kernelParameters = new HashMap<String, String[]>();
            kernelParameters.put("imports", this.getDefaultImports());
            kernelParameters.put("classpath", this.getDefaultClassPath());
            HashMap<String, HashMap<String, String[]>> shell = new HashMap<String, HashMap<String, String[]>>();
            shell.put("beakerx_kernel_parameters", kernelParameters);
            HashMap<String, HashMap<String, HashMap<String, String[]>>> data = new HashMap<String, HashMap<String, HashMap<String, String[]>>>();
            data.put(KERNEL_CONTROL_RESPONSE, shell);
            logger.debug("Response OK");
            this.publish(this.createReplyMessage(message, data));
        }
    }

    @Override
    public String getHandlerCommand() {
        return GET_DEFAULT_SHELL;
    }

    public abstract String[] getDefaultImports();

    public abstract String[] getDefaultClassPath();
}

