/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker.fileloader;

import com.github.lwhite1.tablesaw.api.Table;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.math.NumberUtils;

public class CsvPlotReader {
    private static String TIME_COLUMN = "time";

    public List<Map<?, ?>> convert(Table table) {
        ArrayList result = new ArrayList();
        for (int r = 0; r < table.rowCount(); ++r) {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            for (int c = 0; c < table.columnCount(); ++c) {
                String value = table.get(c, r);
                String headerName = (String)table.columnNames().get(c);
                if (headerName.equals(TIME_COLUMN)) {
                    entry.put(headerName, this.convertDate(value));
                    continue;
                }
                entry.put(headerName, this.convertToNumber(value));
            }
            result.add(entry);
        }
        return result;
    }

    public Table read(String fileName) throws IOException {
        return Table.createFromCsv((String)fileName);
    }

    public List<Map<?, ?>> readAsList(String fileName) throws IOException {
        return this.convert(Table.createFromCsv((String)fileName));
    }

    private Object convertToNumber(Object value) {
        if (value instanceof String && NumberUtils.isNumber((String)((String)value))) {
            return Float.valueOf(Float.parseFloat((String)value));
        }
        return value;
    }

    private Object convertDate(Object x) {
        if (x instanceof Number) {
            return x;
        }
        if (x instanceof Date) {
            Date date = (Date)x;
            return date.getTime();
        }
        if (x instanceof String) {
            Date inputDate = null;
            try {
                inputDate = new SimpleDateFormat("yyyy-MM-dd").parse((String)x);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException("time column accepts String date in a following format yyyy-MM-dd");
            }
            return inputDate.getTime();
        }
        throw new IllegalArgumentException("time column accepts numbers or java.util.Date objects or String date in a following format yyyy-MM-dd");
    }
}

