/*
 * Decompiled with CFR 0.152.
 */
package com.twosigma.beaker;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.twosigma.beaker.jvm.serialization.BeakerObjectConverter;
import com.twosigma.beaker.jvm.serialization.ObjectDeserializer;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeakerProgressUpdate {
    private static final Logger logger = LoggerFactory.getLogger((String)BeakerProgressUpdate.class.getName());
    public final String message;
    public final int progressBar;
    public final Object payload;

    public BeakerProgressUpdate() {
        this.message = "";
        this.progressBar = -1;
        this.payload = null;
    }

    public BeakerProgressUpdate(String m) {
        this.message = m;
        this.progressBar = -1;
        this.payload = null;
    }

    public BeakerProgressUpdate(int pb) {
        this.message = "";
        this.progressBar = pb >= 0 && pb <= 100 ? pb : pb % 100;
        this.payload = null;
    }

    public BeakerProgressUpdate(String m, int pb) {
        this.message = m;
        this.progressBar = pb >= 0 && pb <= 100 ? pb : pb % 100;
        this.payload = null;
    }

    public BeakerProgressUpdate(Object p) {
        this.message = "";
        this.progressBar = -1;
        this.payload = p;
    }

    public BeakerProgressUpdate(String m, Object p) {
        this.message = m;
        this.progressBar = -1;
        this.payload = p;
    }

    public BeakerProgressUpdate(int pb, Object p) {
        this.message = "";
        this.progressBar = pb >= 0 && pb <= 100 ? pb : pb % 100;
        this.payload = p;
    }

    public BeakerProgressUpdate(String m, int pb, Object p) {
        this.message = m;
        this.progressBar = pb >= 0 && pb <= 100 ? pb : pb % 100;
        this.payload = p;
    }

    private BeakerProgressUpdate(String m, Integer pb, Object p) {
        String string = this.message = m != null ? m : "";
        this.progressBar = pb != null ? (pb >= 0 && pb <= 100 ? pb : pb % 100) : -1;
        this.payload = p;
    }

    public static class DeSerializer
    implements ObjectDeserializer {
        private final BeakerObjectConverter parent;

        public DeSerializer(BeakerObjectConverter p) {
            this.parent = p;
            this.parent.addKnownBeakerType("BeakerProgressUpdate");
        }

        @Override
        public Object deserialize(JsonNode n, ObjectMapper mapper) {
            BeakerProgressUpdate o = null;
            try {
                String message = null;
                Object payload = null;
                Integer progressBar = null;
                if (n.has("message")) {
                    message = n.get("message").asText();
                }
                if (n.has("progressBar")) {
                    progressBar = n.get("progressBar").asInt();
                }
                if (n.has("payload")) {
                    payload = this.parent.deserialize(n.get("payload"), mapper);
                }
                o = new BeakerProgressUpdate(message, progressBar, payload);
            }
            catch (Exception e) {
                logger.error("exception deserializing BeakerProgressUpdate ", (Throwable)e);
            }
            return o;
        }

        @Override
        public boolean canBeUsed(JsonNode n) {
            return n.has("type") && n.get("type").asText().equals("BeakerProgressUpdate");
        }
    }

    public static class Serializer
    extends JsonSerializer<BeakerProgressUpdate> {
        private final Provider<BeakerObjectConverter> objectSerializerProvider;

        @Inject
        private Serializer(Provider<BeakerObjectConverter> osp) {
            this.objectSerializerProvider = osp;
        }

        private BeakerObjectConverter getObjectSerializer() {
            return (BeakerObjectConverter)this.objectSerializerProvider.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serialize(BeakerProgressUpdate value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            BeakerProgressUpdate beakerProgressUpdate = value;
            synchronized (beakerProgressUpdate) {
                jgen.writeStartObject();
                jgen.writeStringField("type", "BeakerProgressUpdate");
                jgen.writeStringField("message", value.message);
                jgen.writeNumberField("progressBar", value.progressBar);
                Object obj = value.payload;
                if (obj != null) {
                    jgen.writeFieldName("payload");
                    if (!this.getObjectSerializer().writeObject(obj, jgen, true)) {
                        jgen.writeString(obj.toString());
                    }
                }
                jgen.writeEndObject();
            }
        }
    }
}

