/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.scala;

import java.io.PrintWriter;
import java.io.Writer;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.plugins.scripting.scala.ScalaScriptEngine;
import org.scijava.script.AdaptedScriptLanguage;
import org.scijava.script.ScriptLanguage;
import scala.tools.nsc.ConsoleWriter;
import scala.tools.nsc.NewLinePrintWriter;
import scala.tools.nsc.Settings;
import scala.tools.nsc.interpreter.Scripted;

@Plugin(type=ScriptLanguage.class, name="Scala")
public class ScalaScriptLanguage
extends AdaptedScriptLanguage {
    @Parameter
    private LogService log;

    public ScalaScriptLanguage() {
        super("scala");
    }

    public ScriptEngine getScriptEngine() {
        Settings settings = new Settings();
        settings.classpath().value_$eq((Object)this.getClasspath());
        Scripted eng = Scripted.apply((ScriptEngineFactory)new Scripted.Factory(), (Settings)settings, (PrintWriter)new NewLinePrintWriter((Writer)new ConsoleWriter(), true));
        return new ScalaScriptEngine((ScriptEngine)eng);
    }

    private String getClasspath() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        if (!(cl instanceof URLClassLoader)) {
            this.log.warn((Object)("Cannot retrieve classpath from class loader of type '" + cl.getClass().getName() + "'"));
            return System.getProperty("java.class.path");
        }
        return Arrays.stream(((URLClassLoader)cl).getURLs()).map(url -> url.getPath()).collect(Collectors.joining(System.getProperty("path.separator")));
    }
}

