/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class UnsignedLongType
extends GenericLongType<UnsignedLongType> {
    public UnsignedLongType(NativeImg<?, ? extends LongAccess> img) {
        super(img);
    }

    public UnsignedLongType(long value) {
        super(value);
    }

    public UnsignedLongType(BigInteger value) {
        super((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value.longValue());
    }

    public UnsignedLongType(LongAccess access) {
        super(access);
    }

    public UnsignedLongType() {
        this(0L);
    }

    @Override
    public NativeImg<UnsignedLongType, ? extends LongAccess> createSuitableNativeImg(NativeImgFactory<UnsignedLongType> storageFactory, long[] dim) {
        NativeImg<UnsignedLongType, LongAccess> container = storageFactory.createLongInstance(dim, new Fraction());
        UnsignedLongType linkedType = new UnsignedLongType(container);
        container.setLinkedType(linkedType);
        return container;
    }

    @Override
    public UnsignedLongType duplicateTypeOnSameNativeImg() {
        return new UnsignedLongType(this.img);
    }

    @Override
    public void mul(float c) {
        this.set(Util.round((double)((float)this.get() * c)));
    }

    @Override
    public void mul(double c) {
        this.set(Util.round((double)this.get() * c));
    }

    @Override
    public void add(UnsignedLongType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedLongType c) {
        this.set(UnsignedLongType.divide(this.get(), c.get()));
    }

    public static final long divide(long d1, long d2) {
        if (d2 < 0L) {
            if (-1 == UnsignedLongType.compare(d1, d2)) {
                return 0L;
            }
            return 1L;
        }
        if (d1 < 0L) {
            long quotient;
            long reminder = d1 - (quotient = (d1 >>> 1) / d2 << 1) * d2;
            return quotient + (long)(-1 == UnsignedLongType.compare(d2, reminder) ? 0 : 1);
        }
        return d1 / d2;
    }

    @Override
    public void mul(UnsignedLongType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedLongType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public int hashCode() {
        long value = this.get();
        return (int)(value ^ value >>> 32);
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        this.set(this.get() + 1L);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1L);
    }

    @Override
    public String toString() {
        return "" + this.get();
    }

    public long get() {
        return this.dataAccess.getValue(this.i);
    }

    @Override
    public BigInteger getBigInteger() {
        BigInteger mask = new BigInteger("FFFFFFFFFFFFFFFF", 16);
        return BigInteger.valueOf(this.get()).and(mask);
    }

    @Override
    public void set(long value) {
        this.dataAccess.setValue(this.i, value);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.longValue());
    }

    @Override
    public void set(BigInteger bi) {
        this.set(bi.longValue());
    }

    @Override
    public double getMaxValue() {
        return Math.pow(2.0, 64.0) - 1.0;
    }

    public BigInteger getMaxBigIntegerValue() {
        return new BigInteger("+FFFFFFFFFFFFFFFF", 16);
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public int compareTo(UnsignedLongType c) {
        return UnsignedLongType.compare(this.get(), c.get());
    }

    public static final int compare(long a, long b) {
        if (a == b) {
            return 0;
        }
        boolean test = a < b;
        if (a < 0L != b < 0L) {
            test = !test;
        }
        return test ? -1 : 1;
    }

    @Override
    public UnsignedLongType createVariable() {
        return new UnsignedLongType(0L);
    }

    @Override
    public UnsignedLongType copy() {
        return new UnsignedLongType(this.get());
    }
}

