/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.position.transform;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.Positionable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;

public abstract class AbstractPositionableTransform<LocalizablePositionable extends Localizable & Positionable>
extends AbstractEuclideanSpace
implements RealPositionable,
RealLocalizable {
    protected final LocalizablePositionable target;
    protected final double[] position;
    protected final long[] discrete;

    public AbstractPositionableTransform(LocalizablePositionable target) {
        super(target.numDimensions());
        this.target = target;
        this.position = new double[this.n];
        this.discrete = new long[this.n];
    }

    @Override
    public double getDoublePosition(int dim) {
        return this.position[dim];
    }

    @Override
    public float getFloatPosition(int dim) {
        return (float)this.position[dim];
    }

    @Override
    public void localize(float[] pos) {
        for (int d = 0; d < pos.length; ++d) {
            pos[d] = (float)this.position[d];
        }
    }

    @Override
    public void localize(double[] pos) {
        for (int d = 0; d < pos.length; ++d) {
            pos[d] = this.position[d];
        }
    }

    @Override
    public void bck(int dim) {
        int n = dim;
        this.position[n] = this.position[n] - 1.0;
        ((Positionable)this.target).bck(dim);
    }

    @Override
    public void fwd(int dim) {
        int n = dim;
        this.position[n] = this.position[n] + 1.0;
        ((Positionable)this.target).fwd(dim);
    }

    @Override
    public void move(int distance, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + (double)distance;
        ((Positionable)this.target).move(distance, dim);
    }

    @Override
    public void move(long distance, int dim) {
        int n = dim;
        this.position[n] = this.position[n] + (double)distance;
        ((Positionable)this.target).move(distance, dim);
    }

    @Override
    public void move(Localizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + localizable.getDoublePosition(d);
        }
        ((Positionable)this.target).move(localizable);
    }

    @Override
    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
        ((Positionable)this.target).move(distance);
    }

    @Override
    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
        ((Positionable)this.target).move(distance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
        ((Positionable)this.target).setPosition(localizable);
    }

    @Override
    public void setPosition(int[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        ((Positionable)this.target).setPosition(position);
    }

    @Override
    public void setPosition(long[] position) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = position[d];
        }
        ((Positionable)this.target).setPosition(position);
    }

    @Override
    public void setPosition(int position, int d) {
        this.position[d] = position;
        ((Positionable)this.target).setPosition(position, d);
    }

    @Override
    public void setPosition(long position, int d) {
        this.position[d] = position;
        ((Positionable)this.target).setPosition(position, d);
    }

    public String toString() {
        StringBuffer pos = new StringBuffer("(");
        pos.append(this.position[0]);
        for (int d = 1; d < this.n; ++d) {
            pos.append(", ").append(this.position[d]);
        }
        pos.append(")");
        return pos.toString();
    }
}

