/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.ssa;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.renjin.compiler.ir.ssa.SsaVariable;
import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.ExpressionVisitor;
import org.renjin.compiler.ir.tac.expressions.Variable;
import org.renjin.eval.Context;
import org.renjin.sexp.SEXP;

public class PhiFunction
implements Expression {
    private List<Variable> arguments;

    public PhiFunction(Variable variable, int count) {
        if (count < 2) {
            throw new IllegalArgumentException("variable=" + variable + ", count=" + count + " (count must be >= 2)");
        }
        this.arguments = Lists.newArrayList();
        for (int i = 0; i != count; ++i) {
            this.arguments.add(variable);
        }
    }

    public PhiFunction(List<Variable> arguments) {
        this.arguments = arguments;
    }

    @Override
    public Object retrieveValue(Context context, Object[] temps) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Variable> variables() {
        return Sets.newHashSet(this.arguments);
    }

    public String toString() {
        return "\u03a6(" + Joiner.on((String)", ").join(this.arguments) + ")";
    }

    @Override
    public Expression replaceVariable(Variable name, Variable newName) {
        ArrayList newArguments = Lists.newArrayList();
        for (Variable arg : this.arguments) {
            newArguments.add(arg.equals(name) ? newName : arg);
        }
        return new PhiFunction(newArguments);
    }

    public PhiFunction replaceVariable(int j, int i) {
        ArrayList newArguments = Lists.newArrayList(this.arguments);
        newArguments.set(j, new SsaVariable((Variable)newArguments.get(j), i));
        return new PhiFunction(newArguments);
    }

    public Variable getArgument(int j) {
        return this.arguments.get(j);
    }

    @Override
    public List<Expression> getChildren() {
        return this.arguments;
    }

    @Override
    public void setChild(int childIndex, Expression child) {
        this.arguments.set(childIndex, (Variable)child);
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visitPhiFunction(this);
    }

    @Override
    public SEXP getSExpression() {
        return this.arguments.get(0).getSExpression();
    }
}

