/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.widget;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.scijava.plugin.Plugin;
import org.scijava.ui.swing.widget.SwingInputWidget;
import org.scijava.widget.InputWidget;
import org.scijava.widget.ObjectWidget;
import org.scijava.widget.WidgetModel;

@Plugin(type=InputWidget.class)
public class SwingObjectWidget
extends SwingInputWidget<Object>
implements ActionListener,
ObjectWidget<JPanel> {
    private JComboBox comboBox;

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateModel();
    }

    public Object getValue() {
        return this.comboBox.getSelectedItem();
    }

    @Override
    public void set(WidgetModel model) {
        super.set(model);
        this.comboBox = new JComboBox<Object>(model.getObjectPool().toArray());
        this.setToolTip(this.comboBox);
        this.getComponent().add(this.comboBox);
        this.comboBox.addActionListener(this);
        this.refreshWidget();
    }

    public boolean supports(WidgetModel model) {
        return super.supports(model) && model.getObjectPool().size() > 0;
    }

    public void doRefresh() {
        Object value = this.get().getValue();
        if (value == this.comboBox.getSelectedItem()) {
            return;
        }
        this.comboBox.setSelectedItem(value);
    }
}

