/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.ui.swing.script;

import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.PrintStream;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import org.scijava.script.ScriptREPL;
import org.scijava.ui.swing.script.OutputPane;
import org.scijava.ui.swing.script.VarsPane;
import org.scijava.widget.UIComponent;

public abstract class PromptPane
implements UIComponent<JTextArea> {
    private final ScriptREPL repl;
    private final TextArea textArea = new TextArea(3, 2);
    private final OutputPane output;

    public PromptPane(ScriptREPL repl, final VarsPane vars, OutputPane output) {
        this.textArea.setLineWrap(true);
        this.repl = repl;
        this.output = output;
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                int code = event.getKeyCode();
                switch (code) {
                    case 10: {
                        if (event.isShiftDown()) {
                            PromptPane.this.textArea.insert("\n", PromptPane.this.textArea.getCaretPosition());
                            break;
                        }
                        boolean result = PromptPane.this.execute();
                        event.consume();
                        if (!result) {
                            PromptPane.this.quit();
                        }
                        vars.update();
                        break;
                    }
                    case 40: {
                        if (!PromptPane.this.isInRow(-1)) break;
                        PromptPane.this.down();
                        event.consume();
                        break;
                    }
                    case 38: {
                        if (!PromptPane.this.isInRow(0)) break;
                        PromptPane.this.up();
                        event.consume();
                    }
                }
            }
        });
    }

    public abstract void quit();

    @Override
    public JTextArea getComponent() {
        return this.textArea;
    }

    @Override
    public Class<JTextArea> getComponentType() {
        return JTextArea.class;
    }

    private boolean isInRow(int row) {
        try {
            int rowHeight = this.textArea.getRowHeight();
            Rectangle rect = this.textArea.modelToView(this.textArea.getCaretPosition());
            int rowTop = row * rowHeight;
            if (rowTop < 0) {
                Rectangle lastRect = this.textArea.modelToView(this.textArea.getDocument().getLength());
                rowTop += lastRect.y + lastRect.height;
            }
            return rect.y == rowTop;
        }
        catch (BadLocationException e) {
            e.printStackTrace(new PrintStream(this.output.getOutputStream()));
            return true;
        }
    }

    private void up() {
        this.walk(false);
    }

    private void down() {
        this.walk(true);
    }

    private void walk(boolean forward) {
        this.textArea.setText(this.repl.getInterpreter().walkHistory(this.textArea.getText(), forward));
    }

    private synchronized boolean execute() {
        String text = this.textArea.getText();
        this.output.append(">>> " + text + "\n");
        boolean result = this.repl.evaluate(text);
        this.textArea.setText("");
        return result;
    }

    public class TextArea
    extends JTextArea {
        public TextArea(int rows, int columns) {
            super(rows, columns);
        }

        @Override
        public int getRowHeight() {
            return super.getRowHeight();
        }
    }
}

