/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.threshold.huang;

import net.imagej.ops.Ops;
import net.imagej.ops.threshold.AbstractComputeThresholdHistogram;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Threshold.Huang.class, priority=100.0)
public class ComputeHuangThreshold<T extends RealType<T>>
extends AbstractComputeThresholdHistogram<T>
implements Ops.Threshold.Huang {
    @Override
    public long computeBin(Histogram1d<T> hist) {
        int last;
        int first;
        long[] histogram = hist.toLongArray();
        for (first = 0; first < histogram.length && histogram[first] == 0L; ++first) {
        }
        for (last = histogram.length - 1; last > first && histogram[last] == 0L; --last) {
        }
        if (first == last) {
            return 0L;
        }
        double[] S = new double[last + 1];
        double[] W = new double[last + 1];
        S[0] = histogram[0];
        for (int i = Math.max(1, first); i <= last; ++i) {
            S[i] = S[i - 1] + (double)histogram[i];
            W[i] = W[i - 1] + (double)((long)i * histogram[i]);
        }
        double C = last - first;
        double[] Smu = new double[last + 1 - first];
        for (int i = 1; i < Smu.length; ++i) {
            double mu = 1.0 / (1.0 + (double)Math.abs(i) / C);
            Smu[i] = -mu * Math.log(mu) - (1.0 - mu) * Math.log(1.0 - mu);
        }
        int bestThreshold = 0;
        double bestEntropy = Double.POSITIVE_INFINITY;
        for (int threshold = first; threshold <= last; ++threshold) {
            int i;
            double entropy = 0.0;
            int mu = (int)Math.round(W[threshold] / S[threshold]);
            for (i = first; i <= threshold; ++i) {
                entropy += Smu[Math.abs(i - mu)] * (double)histogram[i];
            }
            mu = (int)Math.round((W[last] - W[threshold]) / (S[last] - S[threshold]));
            for (i = threshold + 1; i <= last; ++i) {
                entropy += Smu[Math.abs(i - mu)] * (double)histogram[i];
            }
            if (!(bestEntropy > entropy)) continue;
            bestEntropy = entropy;
            bestThreshold = threshold;
        }
        return bestThreshold;
    }
}

