/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.thread.chunker;

import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import net.imagej.ops.Ops;
import net.imagej.ops.thread.chunker.AbstractChunker;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Thread.Chunker.class)
public class DefaultChunker
extends AbstractChunker {
    private final int STEP_SIZE = 1;
    @Parameter
    public LogService logService;

    public void run() {
        final int numSteps = Math.max(1, (int)(this.numberOfElements / (long)Runtime.getRuntime().availableProcessors()));
        final int numChunks = (int)(this.numberOfElements / (long)numSteps);
        ArrayList<Future> futures = new ArrayList<Future>(numChunks);
        int i = 0;
        while (i < numChunks - 1) {
            final int j = i++;
            futures.add(this.threadService.run(new Runnable(){

                @Override
                public void run() {
                    DefaultChunker.this.chunkable.execute(j * numSteps, 1, numSteps);
                }
            }));
        }
        futures.add(this.threadService.run(new Runnable(){

            @Override
            public void run() {
                DefaultChunker.this.chunkable.execute((numChunks - 1) * numSteps, 1, (int)((long)numSteps + DefaultChunker.this.numberOfElements % (long)numSteps));
            }
        }));
        for (Future future : futures) {
            try {
                if (this.isCanceled()) break;
                future.get();
            }
            catch (InterruptedException exc) {
                throw new RuntimeException(exc);
            }
            catch (ExecutionException exc) {
                throw new RuntimeException(exc);
            }
        }
    }
}

