/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.filter.addPoissonNoise;

import java.util.Random;
import net.imagej.ops.Ops;
import net.imagej.ops.special.computer.AbstractUnaryComputerOp;
import net.imglib2.type.numeric.RealType;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Filter.AddPoissonNoise.class)
public class AddPoissonNoiseRealType<I extends RealType<I>, O extends RealType<O>>
extends AbstractUnaryComputerOp<I, O>
implements Ops.Filter.AddPoissonNoise {
    @Parameter(required=false)
    private long seed = -6066930261531658096L;
    private Random rng;

    public long getSeed() {
        return this.seed;
    }

    public void setSeed(long seed) {
        this.seed = seed;
    }

    @Override
    public void compute(I input, O output) {
        if (this.rng == null) {
            this.rng = new Random(this.seed);
        }
        double l = Math.exp(-input.getRealDouble());
        int k = 0;
        double p = 1.0;
        do {
            ++k;
        } while ((p *= this.rng.nextDouble()) >= l);
        output.setReal((float)(k - 1));
    }
}

