/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.lbp2d;

import java.util.ArrayList;
import java.util.Iterator;
import net.imagej.ops.Ops;
import net.imagej.ops.features.lbp2d.AbstractLBP2DFeature;
import net.imagej.ops.image.histogram.HistogramCreate;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.histogram.Histogram1d;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.view.Views;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.LBP.LBP2D.class, label="2d Local Binary Pattern")
public class DefaultLBP2D<I extends RealType<I>>
extends AbstractLBP2DFeature<I> {
    @Parameter(required=true)
    private int distance = 1;
    @Parameter(required=true)
    private int histogramSize = 256;
    private UnaryFunctionOp<ArrayList, Histogram1d> histOp;

    @Override
    public void initialize() {
        this.histOp = Functions.unary(this.ops(), HistogramCreate.class, Histogram1d.class, ArrayList.class, new Object[]{this.histogramSize});
    }

    @Override
    public ArrayList<LongType> createOutput(RandomAccessibleInterval<I> input) {
        return new ArrayList<LongType>();
    }

    @Override
    public void compute(RandomAccessibleInterval<I> input, ArrayList<LongType> output) {
        ArrayList<LongType> numberList = new ArrayList<LongType>();
        OutOfBounds raInput = Views.extendZero(input).randomAccess();
        Cursor cInput = Views.flatIterable(input).cursor();
        AbstractLBP2DFeature.ClockwiseDistanceNeighborhoodIterator cNeigh = new AbstractLBP2DFeature.ClockwiseDistanceNeighborhoodIterator(raInput, this.distance);
        while (cInput.hasNext()) {
            cInput.next();
            double centerValue = ((RealType)cInput.get()).getRealDouble();
            int resultBinaryValue = 0;
            cNeigh.reset();
            while (cNeigh.hasNext()) {
                double nValue = ((RealType)cNeigh.next()).getRealDouble();
                int pos = cNeigh.getIndex();
                if (!(nValue >= centerValue)) continue;
                resultBinaryValue |= 1 << pos;
            }
            numberList.add(new LongType((long)resultBinaryValue));
        }
        Histogram1d hist = this.histOp.calculate(numberList);
        Iterator c = hist.iterator();
        while (c.hasNext()) {
            output.add(new LongType(((LongType)c.next()).get()));
        }
    }
}

