/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops.features.haralick;

import net.imagej.ops.Ops;
import net.imagej.ops.features.haralick.AbstractHaralickFeature;
import net.imagej.ops.features.haralick.helper.CoocPXMinusY;
import net.imagej.ops.special.function.Functions;
import net.imagej.ops.special.function.UnaryFunctionOp;
import net.imglib2.IterableInterval;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.DoubleType;
import org.scijava.plugin.Plugin;

@Plugin(type=Ops.Haralick.DifferenceVariance.class, label="Haralick: Difference Variance")
public class DefaultDifferenceVariance<T extends RealType<T>>
extends AbstractHaralickFeature<T>
implements Ops.Haralick.DifferenceVariance {
    private UnaryFunctionOp<double[][], double[]> coocPXMinusYFunc;

    @Override
    public void initialize() {
        super.initialize();
        this.coocPXMinusYFunc = Functions.unary(this.ops(), CoocPXMinusY.class, double[].class, double[][].class, new Object[0]);
    }

    @Override
    public void compute(IterableInterval<T> input, DoubleType output) {
        double[][] matrix = this.getCooccurrenceMatrix(input);
        double[] pxminusy = this.coocPXMinusYFunc.calculate(matrix);
        double sum = 0.0;
        for (int k = 0; k < pxminusy.length; ++k) {
            sum += (double)(k * k) * pxminusy[k];
        }
        output.set(sum);
    }
}

