/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.ops;

import net.imagej.ops.Namespace;
import net.imagej.ops.NamespaceService;
import net.imagej.ops.OpService;
import org.scijava.module.Module;
import org.scijava.module.ModuleItem;
import org.scijava.module.process.AbstractPreprocessorPlugin;
import org.scijava.module.process.PreprocessorPlugin;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=PreprocessorPlugin.class, priority=100.0)
public class NamespacePreprocessor
extends AbstractPreprocessorPlugin {
    @Parameter(required=false)
    private NamespaceService nsService;
    @Parameter(required=false)
    private OpService ops;

    public void process(Module module) {
        if (this.nsService == null || this.ops == null) {
            return;
        }
        for (ModuleItem input : module.getInfo().inputs()) {
            this.assignNamespace(module, input);
        }
    }

    private <T> void assignNamespace(Module module, ModuleItem<T> item) {
        if (module.isInputResolved(item.getName())) {
            return;
        }
        Object defaultValue = null;
        if (Namespace.class.isAssignableFrom(item.getType())) {
            defaultValue = this.nsService.create(item.getType(), this.ops);
        }
        if (defaultValue == null) {
            return;
        }
        item.setValue(module, defaultValue);
        module.resolveInput(item.getName());
    }
}

