/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.util;

public class ColorStream {
    protected static final double goldenRatio = 1.0 / (0.5 * Math.sqrt(5.0) + 0.5);
    protected static final double[] rs = new double[]{1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 1.0};
    protected static final double[] gs = new double[]{0.0, 1.0, 1.0, 1.0, 0.0, 0.0, 0.0};
    protected static final double[] bs = new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 0.0};
    static long i = -1L;

    protected static final int interpolate(double[] xs, int k, int l, double u, double v) {
        return (int)((v * xs[k] + u * xs[l]) * 255.0 + 0.5);
    }

    protected static final int argb(int r, int g, int b) {
        return (r << 8 | g) << 8 | b | 0xFF000000;
    }

    static final int get(long index) {
        double x = goldenRatio * (double)index;
        x -= (double)((long)x);
        int k = (int)(x *= 6.0);
        int l = k + 1;
        double u = x - (double)k;
        double v = 1.0 - u;
        int r = ColorStream.interpolate(rs, k, l, u, v);
        int g = ColorStream.interpolate(gs, k, l, u, v);
        int b = ColorStream.interpolate(bs, k, l, u, v);
        return ColorStream.argb(r, g, b);
    }

    public static final int next() {
        return ColorStream.get(++i);
    }
}

