/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.ArrayList;
import java.util.Set;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransformMap2D;
import mpicbg.models.PointMatch;
import mpicbg.models.TransformMesh;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformMeshMap2D
extends CoordinateTransformMap2D {
    private static final long serialVersionUID = 224883558672239029L;

    public TransformMeshMap2D(TransformMesh t, int width, int height) {
        super(new float[height][width * 2]);
        double[] min = new double[2];
        double[] max = new double[2];
        double[] l = new double[2];
        for (int y = 0; y < this.map.length; ++y) {
            for (int x = 0; x < this.map[y].length; ++x) {
                this.map[y][x] = Float.NaN;
            }
        }
        Set<AffineModel2D> s = t.getAV().keySet();
        for (AffineModel2D ai : s) {
            ArrayList<PointMatch> pm = t.getAV().get(ai);
            TransformMeshMap2D.calculateBoundingBoxInverse(pm, min, max);
            int y = (int)min[1];
            while ((double)y <= max[1]) {
                if (y >= 0 && y < this.map.length) {
                    int x = (int)min[0];
                    while ((double)x <= max[0]) {
                        int xi = 2 * x;
                        if (x >= 0 && xi < this.map[y].length) {
                            l[0] = x;
                            l[1] = y;
                            if (TransformMesh.isInSourcePolygon(pm, l)) {
                                ai.applyInPlace(l);
                                this.map[y][xi] = (float)l[0];
                                this.map[y][xi + 1] = (float)l[1];
                            }
                        }
                        ++x;
                    }
                }
                ++y;
            }
        }
    }

    private static final void calculateBoundingBoxInverse(ArrayList<PointMatch> pm, double[] min, double[] max) {
        double[] first = pm.get(0).getP1().getL();
        min[0] = first[0];
        min[1] = first[1];
        max[0] = first[0];
        max[1] = first[1];
        for (PointMatch p : pm) {
            double[] t = p.getP1().getL();
            if (t[0] < min[0]) {
                min[0] = t[0];
            } else if (t[0] > max[0]) {
                max[0] = t[0];
            }
            if (t[1] < min[1]) {
                min[1] = t[1];
                continue;
            }
            if (!(t[1] > max[1])) continue;
            max[1] = t[1];
        }
    }
}

