/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import ij.IJ;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.models.ErrorStatistic;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileUtil {
    public static final Iterable<Tile<?>[]> generateIndependentGroups(final Set<Tile<?>> tiles, final int maxArrayElements) {
        return new Iterable<Tile<?>[]>(){

            @Override
            public final Iterator<Tile<?>[]> iterator() {
                return new Iterator<Tile<?>[]>(){
                    final HashSet<Tile<?>> remaining;
                    {
                        this.remaining = new HashSet(this.shuffle(tiles));
                    }

                    private final Collection<Tile<?>> shuffle(Collection<Tile<?>> ts) {
                        ArrayList s = new ArrayList(ts);
                        Collections.shuffle(s);
                        return s;
                    }

                    @Override
                    public final boolean hasNext() {
                        return this.remaining.size() > 0;
                    }

                    @Override
                    public Tile<?>[] next() {
                        Tile[] array = new Tile[maxArrayElements];
                        Iterator<Tile<?>> it = this.remaining.iterator();
                        array[0] = it.next();
                        it.remove();
                        int next = 1;
                        block0: while (next < maxArrayElements && it.hasNext()) {
                            Tile<?> t = it.next();
                            for (int i = 0; i < next; ++i) {
                                if (array[i].getConnectedTiles().contains(t)) continue;
                                array[next] = t;
                                ++next;
                                it.remove();
                                continue block0;
                            }
                        }
                        if (maxArrayElements != next) {
                            Tile[] a = new Tile[next];
                            System.arraycopy(array, 0, a, 0, next);
                            return a;
                        }
                        return array;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final void optimizeConcurrently(ErrorStatistic observer, double maxAllowedError, int maxIterations, int maxPlateauwidth, final double damp, TileConfiguration tc, Set<Tile<?>> tiles, Set<Tile<?>> fixedTiles, int nThreads) throws InterruptedException, ExecutionException {
        final ThreadGroup tg = Thread.currentThread().getThreadGroup();
        ExecutorService exe = Executors.newFixedThreadPool(nThreads, new ThreadFactory(){
            final AtomicInteger c = new AtomicInteger(0);

            public Thread newThread(Runnable r) {
                Thread t = new Thread(tg, r, "tile-fit-and-apply-" + this.c.incrementAndGet());
                t.setPriority(5);
                return t;
            }
        });
        try {
            long t0 = System.currentTimeMillis();
            ArrayList shuffledTiles = new ArrayList(tiles.size() - fixedTiles.size());
            for (Tile<?> t : tiles) {
                if (fixedTiles.contains(t)) continue;
                shuffledTiles.add(t);
            }
            Collections.shuffle(shuffledTiles);
            long t1 = System.currentTimeMillis();
            System.out.println("Shuffling took " + (t1 - t0) + " ms");
            int i = 0;
            tc.apply();
            long t2 = System.currentTimeMillis();
            System.out.println("First apply took " + (t2 - t1) + " ms");
            LinkedList futures = new LinkedList();
            final HashSet executingTiles = new HashSet(nThreads);
            for (boolean proceed = i < maxIterations ? true : false; proceed; proceed &= ++i < maxIterations) {
                LinkedList<Tile> pending = new LinkedList<Tile>(shuffledTiles);
                Collections.shuffle(pending);
                while (!pending.isEmpty()) {
                    void var26_28;
                    final Tile tile = (Tile)pending.removeFirst();
                    HashSet hashSet = executingTiles;
                    synchronized (hashSet) {
                        if (TileUtil.intersects(tile.getConnectedTiles(), executingTiles)) {
                            pending.addLast(tile);
                            continue;
                        }
                        executingTiles.add(tile);
                    }
                    futures.add(exe.submit(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                tile.fitModel();
                                tile.apply(damp);
                                HashSet hashSet = executingTiles;
                                synchronized (hashSet) {
                                    executingTiles.remove(tile);
                                }
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }));
                    if (futures.size() <= nThreads * 4) continue;
                    boolean bl = false;
                    while (var26_28 < nThreads) {
                        ((Future)futures.removeFirst()).get();
                        ++var26_28;
                    }
                }
                for (Future future : futures) {
                    future.get();
                }
                executingTiles.clear();
                futures.clear();
                tc.updateErrors();
                observer.add(tc.getError());
                IJ.log((String)(i + ": " + observer.mean + " " + observer.max));
                if (i <= maxPlateauwidth) continue;
                proceed = tc.getError() > maxAllowedError;
                for (int d = maxPlateauwidth; !proceed && d >= 1; d /= 2) {
                    try {
                        proceed |= Math.abs(observer.getWideSlope(d)) > 1.0E-4;
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            long t3 = System.currentTimeMillis();
            System.out.println("Concurrent tile optimization loop took " + (t3 - t2) + " ms, total took " + (t3 - t0) + " ms");
        }
        finally {
            exe.shutdownNow();
        }
    }

    private static boolean intersects(Set<Tile<?>> a, Set<Tile<?>> b) {
        Set<Tile<?>> small;
        Set<Tile<?>> large;
        if (a.size() > b.size()) {
            large = a;
            small = b;
        } else {
            large = b;
            small = a;
        }
        for (Tile<?> t : small) {
            if (!large.contains(t)) continue;
            return true;
        }
        return false;
    }
}

