/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.geom.AffineTransform;
import java.util.Collection;
import mpicbg.models.AbstractAffineModel2D;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RigidModel2D
extends AbstractAffineModel2D<RigidModel2D> {
    private static final long serialVersionUID = 294104229960804720L;
    protected static final int MIN_NUM_MATCHES = 2;
    protected double cos = 1.0;
    protected double sin = 0.0;
    protected double tx = 0.0;
    protected double ty = 0.0;
    protected double itx = 0.0;
    protected double ity = 0.0;

    @Override
    public final int getMinNumMatches() {
        return 2;
    }

    @Override
    public final AffineTransform createAffine() {
        return new AffineTransform(this.cos, this.sin, -this.sin, this.cos, this.tx, this.ty);
    }

    @Override
    public final AffineTransform createInverseAffine() {
        return new AffineTransform(this.cos, -this.sin, this.sin, this.cos, this.itx, this.ity);
    }

    @Override
    public final double[] apply(double[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        double l0 = l[0];
        l[0] = this.cos * l0 - this.sin * l[1] + this.tx;
        l[1] = this.sin * l0 + this.cos * l[1] + this.ty;
    }

    @Override
    public final double[] applyInverse(double[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(double[] l) {
        assert (l.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        double l0 = l[0];
        l[0] = this.cos * l0 + this.sin * l[1] + this.itx;
        l[1] = -this.sin * l0 + this.cos * l[1] + this.ity;
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * pX[i];
            pcy += ww * pY[i];
            qcx += ww * qX[i];
            qcy += ww * qY[i];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double cosd = 0.0;
        double sind = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] qX = q[0];
            double[] qY = q[1];
            double ww = w[i];
            double x1 = pX[i] - pcx;
            double y1 = pY[i] - pcy;
            double x2 = qX[i] - qcx + dx;
            double y2 = qY[i] - qcy + dy;
            sind += ww * (x1 * y2 - y1 * x2);
            cosd += ww * (x1 * x2 + y1 * y2);
        }
        double norm = Math.sqrt(cosd * cosd + sind * sind);
        this.cos = cosd /= norm;
        this.sin = sind /= norm;
        this.tx = qcx - cosd * pcx + sind * pcy;
        this.ty = qcy - sind * pcx - cosd * pcy;
        this.invert();
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException {
        assert (p.length >= 2 && q.length >= 2) : "2d rigid transformations can be applied to 2d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 2) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double cosd = 0.0;
        double sind = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] qX = q[0];
            float[] qY = q[1];
            double ww = w[i];
            double x1 = (double)pX[i] - pcx;
            double y1 = (double)pY[i] - pcy;
            double x2 = (double)qX[i] - qcx + dx;
            double y2 = (double)qY[i] - qcy + dy;
            sind += ww * (x1 * y2 - y1 * x2);
            cosd += ww * (x1 * x2 + y1 * y2);
        }
        double norm = Math.sqrt(cosd * cosd + sind * sind);
        this.cos = cosd /= norm;
        this.sin = sind /= norm;
        this.tx = qcx - cosd * pcx + sind * pcy;
        this.ty = qcy - sind * pcx - cosd * pcy;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 2) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d rigid model, at least " + 2 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            qcx += w * q[0];
            qcy += w * q[1];
        }
        double dx = (pcx /= ws) - (qcx /= ws);
        double dy = (pcy /= ws) - (qcy /= ws);
        double cosd = 0.0;
        double sind = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            double x1 = p[0] - pcx;
            double y1 = p[1] - pcy;
            double x2 = q[0] - qcx + dx;
            double y2 = q[1] - qcy + dy;
            sind += w * (x1 * y2 - y1 * x2);
            cosd += w * (x1 * x2 + y1 * y2);
        }
        double norm = Math.sqrt(cosd * cosd + sind * sind);
        this.cos = cosd /= norm;
        this.sin = sind /= norm;
        this.tx = qcx - cosd * pcx + sind * pcy;
        this.ty = qcy - sind * pcx - cosd * pcy;
        this.invert();
    }

    @Override
    public RigidModel2D copy() {
        RigidModel2D m = new RigidModel2D();
        m.cos = this.cos;
        m.sin = this.sin;
        m.tx = this.tx;
        m.ty = this.ty;
        m.itx = this.itx;
        m.ity = this.ity;
        m.cost = this.cost;
        return m;
    }

    @Override
    public final void set(RigidModel2D m) {
        this.cos = m.cos;
        this.sin = m.sin;
        this.tx = m.tx;
        this.ty = m.ty;
        this.itx = m.itx;
        this.ity = m.ity;
        this.cost = m.cost;
    }

    private final void invert() {
        this.itx = -this.sin * this.ty - this.cos * this.tx;
        this.ity = this.sin * this.tx - this.cos * this.ty;
    }

    @Override
    public final void preConcatenate(RigidModel2D model) {
        double a = model.cos * this.cos - model.sin * this.sin;
        double b = model.sin * this.cos + model.cos * this.sin;
        double c = model.cos * this.tx - model.sin * this.ty + model.tx;
        double d = model.sin * this.tx + model.cos * this.ty + model.ty;
        this.cos = a;
        this.sin = b;
        this.tx = c;
        this.ty = d;
        this.invert();
    }

    @Override
    public final void concatenate(RigidModel2D model) {
        double a = this.cos * model.cos - this.sin * model.sin;
        double b = this.sin * model.cos + this.cos * model.sin;
        double c = this.cos * model.tx - this.sin * model.ty + this.tx;
        double d = this.sin * model.tx + this.cos * model.ty + this.ty;
        this.cos = a;
        this.sin = b;
        this.tx = c;
        this.ty = d;
        this.invert();
    }

    public final void set(double theta, double tx, double ty) {
        this.set(Math.cos(theta), Math.sin(theta), tx, ty);
    }

    public final void set(double cos, double sin, double tx, double ty) {
        this.cos = cos;
        this.sin = sin;
        this.tx = tx;
        this.ty = ty;
        this.invert();
    }

    @Override
    public RigidModel2D createInverse() {
        RigidModel2D ict = new RigidModel2D();
        ict.cos = this.cos;
        ict.sin = -this.sin;
        ict.tx = this.itx;
        ict.ty = this.ity;
        ict.itx = this.tx;
        ict.ity = this.ty;
        ict.cost = this.cost;
        return ict;
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.cos;
        data[1] = this.sin;
        data[2] = -this.sin;
        data[3] = this.cos;
        data[4] = this.tx;
        data[5] = this.ty;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.cos;
        data[0][1] = -this.sin;
        data[0][2] = this.tx;
        data[1][0] = this.sin;
        data[1][1] = this.cos;
        data[1][1] = this.ty;
    }
}

