/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.morphology;

import java.util.List;
import java.util.Vector;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.algorithm.morphology.MorphologyUtils;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.algorithm.neighborhood.Shape;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.multithreading.Chunk;
import net.imglib2.multithreading.SimpleMultiThreading;
import net.imglib2.type.Type;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;

public class Erosion {
    public static <T extends RealType<T>> Img<T> erode(Img<T> source, List<Shape> strels, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Erosion.erodeFull(target, strel, numThreads);
        }
        return MorphologyUtils.copyCropped(target, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> erode(Img<T> source, List<Shape> strels, T maxVal, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Erosion.erodeFull(target, strel, maxVal, numThreads);
        }
        return MorphologyUtils.copyCropped(target, source, numThreads);
    }

    public static <T extends RealType<T>> Img<T> erode(Img<T> source, Shape strel, int numThreads) {
        Img target = source.factory().create(source, (Object)((RealType)source.firstElement()).copy());
        RealType maxVal = (RealType)((RealType)source.firstElement()).createVariable();
        maxVal.setReal(maxVal.getMaxValue());
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, (Type)maxVal);
        Erosion.erode(extended, target, strel, numThreads);
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> erode(Img<T> source, Shape strel, T maxVal, int numThreads) {
        Img target = source.factory().create(source, (Object)((Type)source.firstElement()).copy());
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, maxVal);
        Erosion.erode(extended, target, strel, maxVal, numThreads);
        return target;
    }

    public static <T extends RealType<T>> void erode(RandomAccessible<T> source, IterableInterval<T> target, List<Shape> strels, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, target);
        maxVal.setReal(maxVal.getMaxValue());
        Erosion.erode(source, target, strels, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void erode(RandomAccessible<T> source, IterableInterval<T> target, List<Shape> strels, T maxVal, int numThreads) {
        if (strels.isEmpty()) {
            return;
        }
        if (strels.size() == 1) {
            Erosion.erode(source, target, strels.get(0), maxVal, numThreads);
            return;
        }
        long[] targetDims = new long[target.numDimensions()];
        long[] translation = new long[target.numDimensions()];
        for (int d = 0; d < targetDims.length; ++d) {
            targetDims[d] = target.dimension(d);
            translation[d] = target.min(d);
        }
        for (Shape strel : strels) {
            Neighborhood<BitType> nh = MorphologyUtils.getNeighborhood(strel, target);
            for (int d = 0; d < translation.length; ++d) {
                int n = d;
                translation[n] = translation[n] - nh.dimension(d) / 2L;
                int n2 = d;
                targetDims[n2] = targetDims[n2] + (nh.dimension(d) - 1L);
            }
        }
        ImgFactory<T> factory = MorphologyUtils.getSuitableFactory(targetDims, maxVal);
        Img<T> temp = factory.create(targetDims, maxVal);
        IntervalView translated = Views.translate((RandomAccessibleInterval)temp, (long[])translation);
        Erosion.erode(source, translated, strels.get(0), maxVal, numThreads);
        for (int i = 1; i < strels.size(); ++i) {
            temp = Erosion.erode(temp, strels.get(i), maxVal, numThreads);
        }
        long[] offset = new long[target.numDimensions()];
        for (int d = 0; d < offset.length; ++d) {
            offset[d] = target.min(d) - (temp.dimension(d) - target.dimension(d)) / 2L;
        }
        MorphologyUtils.copy2(Views.translate(temp, (long[])offset), target, numThreads);
    }

    public static <T extends RealType<T>> void erode(RandomAccessible<T> source, IterableInterval<T> target, Shape strel, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, target);
        maxVal.setReal(maxVal.getMaxValue());
        Erosion.erode(source, target, strel, maxVal, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void erode(RandomAccessible<T> source, final IterableInterval<T> target, Shape strel, T maxVal, int numThreads) {
        numThreads = Math.max(1, numThreads);
        final RandomAccessible<Neighborhood<T>> accessible = strel.neighborhoodsRandomAccessible(source);
        Vector<Chunk> chunks = SimpleMultiThreading.divideIntoChunks(target.size(), numThreads);
        Thread[] threads = SimpleMultiThreading.newThreads(numThreads);
        T tmp = maxVal;
        if (tmp instanceof BitType) {
            for (int i = 0; i < threads.length; ++i) {
                final Chunk chunk = chunks.get(i);
                threads[i] = new Thread("Morphology erode thread " + i){

                    @Override
                    public void run() {
                        Cursor tmp2;
                        RandomAccess randomAccess = accessible.randomAccess((Interval)target);
                        Cursor cursorTarget = tmp2 = target.cursor();
                        cursorTarget.jumpFwd(chunk.getStartPosition());
                        block0: for (long steps = 0L; steps < chunk.getLoopSize(); ++steps) {
                            cursorTarget.fwd();
                            randomAccess.setPosition((Localizable)cursorTarget);
                            Object tmp3 = randomAccess.get();
                            Neighborhood neighborhood = (Neighborhood)tmp3;
                            Cursor nc = neighborhood.cursor();
                            ((BitType)cursorTarget.get()).set(true);
                            while (nc.hasNext()) {
                                nc.fwd();
                                BitType val = (BitType)nc.get();
                                if (val.get()) continue;
                                ((BitType)cursorTarget.get()).set(false);
                                continue block0;
                            }
                        }
                    }
                };
            }
        } else {
            for (int i = 0; i < threads.length; ++i) {
                Chunk chunk = chunks.get(i);
                threads[i] = new Thread("Morphology erode thread " + i, (RandomAccessible)accessible, (IterableInterval)target, chunk, (RandomAccessible)source, (Type)maxVal){
                    final /* synthetic */ RandomAccessible val$accessible;
                    final /* synthetic */ IterableInterval val$target;
                    final /* synthetic */ Chunk val$chunk;
                    final /* synthetic */ RandomAccessible val$source;
                    final /* synthetic */ Type val$maxVal;
                    {
                        this.val$accessible = randomAccessible;
                        this.val$target = iterableInterval;
                        this.val$chunk = chunk;
                        this.val$source = randomAccessible2;
                        this.val$maxVal = type;
                        super(x0);
                    }

                    @Override
                    public void run() {
                        RandomAccess randomAccess = this.val$accessible.randomAccess((Interval)this.val$target);
                        Cursor cursorTarget = this.val$target.cursor();
                        cursorTarget.jumpFwd(this.val$chunk.getStartPosition());
                        Object max = MorphologyUtils.createVariable(this.val$source, (Interval)this.val$target);
                        for (long steps = 0L; steps < this.val$chunk.getLoopSize(); ++steps) {
                            cursorTarget.fwd();
                            randomAccess.setPosition((Localizable)cursorTarget);
                            Neighborhood neighborhood = (Neighborhood)randomAccess.get();
                            Cursor nc = neighborhood.cursor();
                            max.set(this.val$maxVal);
                            while (nc.hasNext()) {
                                nc.fwd();
                                Type val = (Type)nc.get();
                                if (((Comparable)val).compareTo(max) >= 0) continue;
                                max.set(val);
                            }
                            ((Type)cursorTarget.get()).set(max);
                        }
                    }
                };
            }
        }
        SimpleMultiThreading.startAndJoin(threads);
    }

    public static <T extends RealType<T>> Img<T> erodeFull(Img<T> source, List<Shape> strels, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Erosion.erodeFull(target, strel, numThreads);
        }
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> erodeFull(Img<T> source, List<Shape> strels, T maxVal, int numThreads) {
        Img<T> target = source;
        for (Shape strel : strels) {
            target = Erosion.erodeFull(target, strel, maxVal, numThreads);
        }
        return target;
    }

    public static <T extends RealType<T>> Img<T> erodeFull(Img<T> source, Shape strel, int numThreads) {
        long[][] dimensionsAndOffset = MorphologyUtils.computeTargetImageDimensionsAndOffset(source, strel);
        long[] targetDims = dimensionsAndOffset[0];
        long[] offset = dimensionsAndOffset[1];
        Img target = source.factory().create(targetDims, (Object)((RealType)source.firstElement()).copy());
        IntervalView offsetTarget = Views.offset((RandomAccessibleInterval)target, (long[])offset);
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, source);
        maxVal.setReal(maxVal.getMaxValue());
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, (Type)maxVal);
        Erosion.erode(extended, offsetTarget, strel, numThreads);
        return target;
    }

    public static <T extends Type<T> & Comparable<T>> Img<T> erodeFull(Img<T> source, Shape strel, T maxVal, int numThreads) {
        long[][] dimensionsAndOffset = MorphologyUtils.computeTargetImageDimensionsAndOffset(source, strel);
        long[] targetDims = dimensionsAndOffset[0];
        long[] offset = dimensionsAndOffset[1];
        Img target = source.factory().create(targetDims, (Object)((Type)source.firstElement()).copy());
        IntervalView offsetTarget = Views.offset((RandomAccessibleInterval)target, (long[])offset);
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, maxVal);
        Erosion.erode(extended, offsetTarget, strel, maxVal, numThreads);
        return target;
    }

    public static <T extends RealType<T>> void erodeInPlace(RandomAccessible<T> source, Interval interval, List<Shape> strels, int numThreads) {
        for (Shape strel : strels) {
            Erosion.erodeInPlace(source, interval, strel, numThreads);
        }
    }

    public static <T extends Type<T> & Comparable<T>> void erodeInPlace(RandomAccessibleInterval<T> source, Interval interval, List<Shape> strels, T maxVal, int numThreads) {
        for (Shape strel : strels) {
            Erosion.erodeInPlace(source, interval, strel, maxVal, numThreads);
        }
    }

    public static <T extends RealType<T>> void erodeInPlace(RandomAccessible<T> source, Interval interval, Shape strel, int numThreads) {
        RealType maxVal = (RealType)MorphologyUtils.createVariable(source, interval);
        ImgFactory<RealType> factory = MorphologyUtils.getSuitableFactory((Dimensions)interval, maxVal);
        Img img = factory.create((Dimensions)interval, (Object)maxVal);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Erosion.erode(source, translated, strel, numThreads);
        MorphologyUtils.copy(translated, source, numThreads);
    }

    public static <T extends Type<T> & Comparable<T>> void erodeInPlace(RandomAccessibleInterval<T> source, Interval interval, Shape strel, T maxVal, int numThreads) {
        ExtendedRandomAccessibleInterval extended = Views.extendValue(source, maxVal);
        ImgFactory<T> factory = MorphologyUtils.getSuitableFactory((Dimensions)interval, maxVal);
        Img img = factory.create((Dimensions)interval, maxVal);
        long[] min = new long[interval.numDimensions()];
        interval.min(min);
        IntervalView translated = Views.translate((RandomAccessibleInterval)img, (long[])min);
        Erosion.erode(extended, translated, strel, maxVal, numThreads);
        MorphologyUtils.copy(translated, extended, numThreads);
    }

    private Erosion() {
    }
}

