/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jython.shaded.com.kenai.jffi;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.scijava.jython.shaded.com.kenai.jffi.Foreign;
import org.scijava.jython.shaded.com.kenai.jffi.Type;

public abstract class Aggregate
extends Type {
    private final Type.TypeInfo typeInfo;
    private final Foreign foreign;

    Aggregate(Foreign foreign, long handle) {
        if (handle == 0L) {
            throw new NullPointerException("Invalid ffi_type handle");
        }
        this.foreign = foreign;
        this.typeInfo = new Type.TypeInfo(handle, foreign.getTypeType(handle), foreign.getTypeSize(handle), foreign.getTypeAlign(handle));
    }

    @Override
    final Type.TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public final synchronized void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.foreign.freeAggregate(this.typeInfo.handle);
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Exception when freeing FFI aggregate: %s", t.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }
}

