/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.File;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import jnr.posix.POSIXFactory;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;

class RegularFileResource
implements FileResource {
    private final JRubyFile file;
    private final POSIX symlinkPosix = POSIXFactory.getPOSIX();

    RegularFileResource(File file2) {
        this(file2.getAbsolutePath());
    }

    protected RegularFileResource(String filename2) {
        this.file = new JRubyFile(filename2);
    }

    @Override
    public String absolutePath() {
        return this.file.getAbsolutePath();
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean exists() {
        return this.file.exists() || this.isSymLink();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isSymLink() {
        try {
            return this.symlinkPosix.lstat(this.absolutePath()).isSymlink();
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public String[] list() {
        String[] fileList = this.file.list();
        if (fileList != null) {
            String[] list2 = new String[fileList.length + 2];
            list2[0] = ".";
            list2[1] = "..";
            for (int i2 = 0; i2 < fileList.length; ++i2) {
                list2[i2 + 2] = fileList[i2];
            }
            fileList = list2;
        }
        return fileList;
    }

    @Override
    public FileStat stat(POSIX posix) {
        return posix.stat(this.absolutePath());
    }

    @Override
    public FileStat lstat(POSIX posix) {
        return posix.lstat(this.absolutePath());
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return this.file;
    }
}

