/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;
import org.jruby.util.URLUtil;

public class JRubyUtilLibrary
implements Library {
    @Override
    public void load(Ruby runtime, boolean wrap2) throws IOException {
        RubyModule mJRubyUtil = runtime.getOrCreateModule("JRuby").defineModuleUnder("Util");
        mJRubyUtil.defineAnnotatedMethods(JRubyUtilLibrary.class);
        runtime.getString().defineAnnotatedMethods(StringUtils.class);
    }

    @JRubyMethod(module=true)
    public static IRubyObject gc(IRubyObject recv2) {
        System.gc();
        return recv2.getRuntime().getNil();
    }

    @JRubyMethod(name={"objectspace"}, module=true)
    public static IRubyObject getObjectSpaceEnabled(IRubyObject recv2) {
        Ruby runtime = recv2.getRuntime();
        return RubyBoolean.newBoolean(runtime, runtime.isObjectSpaceEnabled());
    }

    @JRubyMethod(name={"objectspace="}, module=true)
    public static IRubyObject setObjectSpaceEnabled(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime = recv2.getRuntime();
        runtime.setObjectSpaceEnabled(arg2.isTrue());
        return runtime.getNil();
    }

    @JRubyMethod(name={"classloader_resources"}, module=true)
    public static IRubyObject getClassLoaderResources(IRubyObject recv2, IRubyObject arg2) {
        Ruby runtime = recv2.getRuntime();
        String resource2 = arg2.convertToString().toString();
        ArrayList<RubyString> urlStrings = new ArrayList<RubyString>();
        try {
            Enumeration<URL> urls = runtime.getJRubyClassLoader().getResources(resource2);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                String urlString = URLUtil.getPath(url);
                urlStrings.add(runtime.newString(urlString));
            }
            return RubyArray.newArrayNoCopy(runtime, urlStrings.toArray(new IRubyObject[urlStrings.size()]));
        }
        catch (IOException ignore) {
            return runtime.newEmptyArray();
        }
    }

    public static class StringUtils {
        @JRubyMethod
        public static IRubyObject unseeded_hash(ThreadContext context, IRubyObject recv2) {
            Ruby runtime = context.runtime;
            if (!(recv2 instanceof RubyString)) {
                throw runtime.newTypeError(recv2, runtime.getString());
            }
            return runtime.newFixnum(((RubyString)recv2).unseededStrHashCode(runtime));
        }
    }
}

