/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.Plane;
import io.scif.config.SCIFIOConfig;
import io.scif.io.IRandomAccess;
import io.scif.io.RandomAccessInputStream;
import io.scif.io.ZipHandle;
import io.scif.services.FormatService;
import io.scif.services.InitializeService;
import io.scif.services.LocationService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.imglib2.display.ColorTable;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Zip")
public class ZipFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"zip"};
    }

    private static class ZipUtilities {
        private ZipUtilities() {
        }

        public static String unzipId(LocationService locationService, RandomAccessInputStream stream, List<String> mappedFiles) throws IOException {
            ZipInputStream zip = new ZipInputStream(stream);
            ZipEntry ze = null;
            while ((ze = zip.getNextEntry()) != null) {
                ZipHandle handle = new ZipHandle(locationService.getContext(), stream.getFileName(), ze);
                locationService.mapFile(ze.getName(), handle);
                if (mappedFiles == null) continue;
                mappedFiles.add(ze.getName());
            }
            ZipHandle base = new ZipHandle(locationService.getContext(), stream.getFileName());
            String id = base.getEntryName();
            base.close();
            return id;
        }

        public static RandomAccessInputStream getRawStream(LocationService locationService, RandomAccessInputStream stream) throws IOException {
            String id = stream.getFileName();
            IRandomAccess rawHandle = locationService.getHandle(id, false, false);
            return new RandomAccessInputStream(locationService.getContext(), rawHandle, id);
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Parameter
        private LocationService locationService;
        @Parameter
        private FormatService formatService;
        @Parameter
        private InitializeService initializeService;
        private io.scif.Reader reader;

        @Override
        protected String[] createDomainArray() {
            return new String[]{"Unknown"};
        }

        @Override
        public void setSource(RandomAccessInputStream stream, SCIFIOConfig config) throws IOException {
            super.setSource(ZipUtilities.getRawStream(this.locationService, stream), config);
            if (this.reader != null) {
                this.reader.close();
            }
            String baseId = ZipUtilities.unzipId(this.locationService, stream, null);
            try {
                this.reader = this.formatService.getFormat(baseId, config).createReader();
                this.reader.setSource(baseId, config);
            }
            catch (FormatException e) {
                this.log().error((Object)"Failed to set delegate Reader's source", (Throwable)e);
            }
        }

        @Override
        public void setMetadata(Metadata meta) throws IOException {
            super.setMetadata(meta);
            if (this.reader != null) {
                this.reader.close();
            }
            try {
                String baseId = ZipUtilities.unzipId(this.locationService, meta.getSource(), null);
                this.reader = this.initializeService.initializeReader(baseId);
                meta.setMetadata(this.reader.getMetadata());
            }
            catch (FormatException e) {
                this.log().error((Object)"Failed to initialize delegate Reader", (Throwable)e);
            }
        }

        @Override
        public void setNormalized(boolean normalize) {
            if (this.reader != null) {
                this.reader.setNormalized(normalize);
            }
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Plane p = this.reader.openPlane(imageIndex, planeIndex, plane, planeMin, planeMax, config);
            System.arraycopy(p.getBytes(), 0, plane.getData(), 0, ((byte[])plane.getData()).length);
            plane.setColorTable(((Metadata)this.getMetadata()).getColorTable(imageIndex, planeIndex));
            return plane;
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            super.close(fileOnly);
            if (this.reader != null) {
                this.reader.close(fileOnly);
            }
            if (!fileOnly) {
                this.reader = null;
            }
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Parameter
        private LocationService locationService;
        @Parameter
        private FormatService formatService;

        @Override
        public Metadata parse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            return super.parse(ZipUtilities.getRawStream(this.locationService, stream), meta, config);
        }

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            String baseId = ZipUtilities.unzipId(this.locationService, stream, meta.getMappedFiles());
            io.scif.Parser p = this.formatService.getFormat(baseId, config).createParser();
            io.scif.Metadata m = p.parse(baseId, config);
            meta.setMetadata(m);
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        @Parameter
        private LocationService locationService;
        private io.scif.Metadata metadata;
        private List<String> mappedFiles = new ArrayList<String>();

        public List<String> getMappedFiles() {
            return this.mappedFiles;
        }

        public void setMetadata(io.scif.Metadata m) throws IOException {
            if (this.metadata != null) {
                this.metadata.close();
            }
            this.metadata = m;
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            if (HasColorTable.class.isAssignableFrom(this.metadata.getClass())) {
                return ((HasColorTable)((Object)this.metadata)).getColorTable(imageIndex, planeIndex);
            }
            return null;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(0);
            for (ImageMetadata meta : this.metadata.getAll()) {
                this.add(meta);
            }
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            for (String name : this.mappedFiles) {
                IRandomAccess handle = this.locationService.getMappedFile(name);
                this.locationService.mapFile(name, null);
                if (handle == null) continue;
                handle.close();
            }
            this.mappedFiles.clear();
            super.close(fileOnly);
            if (this.metadata != null) {
                this.metadata.close(fileOnly);
            }
            if (!fileOnly) {
                this.metadata = null;
            }
            this.mappedFiles = new ArrayList<String>();
        }
    }
}

