/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.imagej.axis.Axes;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="OBF")
public class OBFFormat
extends AbstractFormat {
    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"obf", "msr"};
    }

    private static class Frame {
        private byte[] bytes;
        private int imageIndex;
        private int number;

        private Frame() {
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public int getImageIndex() {
            return this.imageIndex;
        }

        public void setImageIndex(int series) {
            this.imageIndex = series;
        }

        public int getNumber() {
            return this.number;
        }

        public void setNumber(int number) {
            this.number = number;
        }
    }

    private static class Stack {
        private long position;
        private long length;
        private boolean compression;

        private Stack() {
        }

        public long getPosition() {
            return this.position;
        }

        public void setPosition(long position) {
            this.position = position;
        }

        public long getLength() {
            return this.length;
        }

        public void setLength(long length) {
            this.length = length;
        }

        public boolean isCompression() {
            return this.compression;
        }

        public void setCompression(boolean compression) {
            this.compression = compression;
        }
    }

    private static class OBFUtilities {
        private static final short MAGIC_NUMBER = -1;
        private static final boolean LITTLE_ENDIAN = true;
        private static final String FILE_MAGIC_STRING = "OMAS_BF\n";

        private OBFUtilities() {
        }

        public static int getPixelType(int type) throws FormatException {
            switch (type) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 0;
                }
                case 4: {
                    return 3;
                }
                case 8: {
                    return 2;
                }
                case 16: {
                    return 5;
                }
                case 32: {
                    return 4;
                }
                case 64: {
                    return 6;
                }
                case 128: {
                    return 7;
                }
            }
            throw new FormatException("Unsupported data type " + type);
        }

        public static int getBitsPerPixel(int type) throws FormatException {
            switch (type) {
                case 1: 
                case 2: {
                    return 8;
                }
                case 4: 
                case 8: {
                    return 16;
                }
                case 16: 
                case 32: {
                    return 32;
                }
                case 64: {
                    return 32;
                }
                case 128: {
                    return 64;
                }
            }
            throw new FormatException("Unsupported data type " + type);
        }

        public static int getFileVersion(RandomAccessInputStream stream) throws IOException {
            if (!FormatTools.validStream(stream, FILE_MAGIC_STRING.length(), false)) {
                return -1;
            }
            stream.seek(0L);
            stream.order(true);
            try {
                String magicString = stream.readString(FILE_MAGIC_STRING.length());
                short magicNumber = stream.readShort();
                int version = stream.readInt();
                if (magicString.equals(FILE_MAGIC_STRING) && magicNumber == -1) {
                    return version;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return -1;
        }
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Unknown"};
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            Metadata meta = (Metadata)this.getMetadata();
            byte[] buffer = plane.getBytes();
            int xAxis = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yAxis = meta.get(imageIndex).getAxisIndex(Axes.Y);
            int x = (int)planeMin[xAxis];
            int y = (int)planeMin[yAxis];
            int w = (int)planeMax[xAxis];
            int h = (int)planeMax[yAxis];
            int rows = (int)meta.get(imageIndex).getAxisLength(Axes.Y);
            int columns = (int)meta.get(imageIndex).getAxisLength(Axes.X);
            int bytesPerPixel = meta.get(imageIndex).getBitsPerPixel() / 8;
            Stack stack = meta.getStacks().get(imageIndex);
            if (stack.isCompression()) {
                Frame cInflatedFrame = meta.getCurrentInflatedFrame();
                if (imageIndex != cInflatedFrame.getImageIndex()) {
                    cInflatedFrame.setBytes(new byte[rows * columns * bytesPerPixel]);
                    cInflatedFrame.setImageIndex(imageIndex);
                    cInflatedFrame.setNumber(-1);
                }
                byte[] bytes = cInflatedFrame.getBytes();
                if (planeIndex != (long)cInflatedFrame.getNumber()) {
                    if (planeIndex < (long)cInflatedFrame.getNumber()) {
                        cInflatedFrame.setNumber(-1);
                    }
                    if (cInflatedFrame.getNumber() == -1) {
                        this.getStream().seek(stack.getPosition());
                        meta.getInflater().reset();
                    }
                    byte[] input = new byte[8192];
                    while (planeIndex != (long)cInflatedFrame.getNumber()) {
                        for (int offset = 0; offset != bytes.length; offset += meta.getInflater().inflate(bytes, offset, bytes.length - offset)) {
                            if (meta.getInflater().needsInput()) {
                                long remainder = stack.getPosition() + stack.getLength() - this.getStream().getFilePointer();
                                if (remainder <= 0L) throw new FormatException("Corrupted zlib compression");
                                int length = remainder > (long)input.length ? input.length : (int)remainder;
                                this.getStream().read(input, 0, length);
                                meta.getInflater().setInput(input, 0, length);
                            } else if (meta.getInflater().needsDictionary()) {
                                throw new FormatException("Unsupported zlib compression");
                            }
                            try {
                                continue;
                            }
                            catch (DataFormatException exception) {
                                throw new FormatException(exception.getMessage());
                            }
                        }
                        cInflatedFrame.setNumber(cInflatedFrame.getNumber() + 1);
                    }
                }
                for (int row = 0; row != h; ++row) {
                    System.arraycopy(bytes, ((row + y) * columns + x) * bytesPerPixel, buffer, row * w * bytesPerPixel, w * bytesPerPixel);
                }
                return plane;
            } else {
                for (int row = 0; row != h; ++row) {
                    this.getStream().seek(stack.getPosition() + ((planeIndex * (long)rows + (long)row + (long)y) * (long)columns + (long)x) * (long)bytesPerPixel);
                    this.getStream().read(buffer, row * w * bytesPerPixel, w * bytesPerPixel);
                }
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private static final int STACK_VERSION = 3;
        private static final String STACK_MAGIC_STRING = "OMAS_BF_STACK\n";
        private static final int MAXIMAL_NUMBER_OF_DIMENSIONS = 15;

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            meta.getCurrentInflatedFrame().setImageIndex(-1);
            meta.getCurrentInflatedFrame().setNumber(-1);
            int fileVersion = OBFUtilities.getFileVersion(stream);
            long stackPosition = stream.readLong();
            int lengthOfDescription = stream.readInt();
            String description = stream.readString(lengthOfDescription);
            meta.getTable().put("Description", description);
            if (stackPosition != 0L) {
                meta.createImageMetadata(1);
                while ((stackPosition = this.initStack(stackPosition, fileVersion)) != 0L) {
                }
            }
        }

        private long initStack(long current, int fileVersion) throws FormatException, IOException {
            this.getSource().seek(current);
            String magicString = this.getSource().readString(STACK_MAGIC_STRING.length());
            short magicNumber = this.getSource().readShort();
            int version = this.getSource().readInt();
            if (magicString.equals(STACK_MAGIC_STRING) && magicNumber == -1 && version <= 3) {
                ImageMetadata iMeta = ((Metadata)this.getMetadata()).get(0);
                iMeta.setLittleEndian(true);
                iMeta.setThumbnail(false);
                int numberOfDimensions = this.getSource().readInt();
                if (numberOfDimensions > 5) {
                    throw new FormatException("Unsupported number of " + numberOfDimensions + " dimensions");
                }
                int[] sizes = new int[15];
                for (int dimension = 0; dimension != 15; ++dimension) {
                    int size = this.getSource().readInt();
                    sizes[dimension] = dimension < numberOfDimensions ? size : 1;
                }
                iMeta.setAxisLength(Axes.X, (long)sizes[0]);
                iMeta.setAxisLength(Axes.Y, (long)sizes[1]);
                iMeta.setAxisLength(Axes.Z, (long)sizes[2]);
                iMeta.setAxisLength(Axes.CHANNEL, (long)sizes[3]);
                iMeta.setAxisLength(Axes.TIME, (long)sizes[4]);
                ArrayList<Double> lengths = new ArrayList<Double>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    double length = this.getSource().readDouble();
                    if (dimension >= numberOfDimensions) continue;
                    lengths.add(new Double(length));
                }
                iMeta.getTable().put("Lengths", lengths);
                ArrayList<Double> offsets = new ArrayList<Double>();
                for (int dimension = 0; dimension != 15; ++dimension) {
                    double offset = this.getSource().readDouble();
                    if (dimension >= numberOfDimensions) continue;
                    offsets.add(new Double(offset));
                }
                iMeta.getTable().put("Offsets", offsets);
                int type = this.getSource().readInt();
                iMeta.setPixelType(OBFUtilities.getPixelType(type));
                iMeta.setPixelType(OBFUtilities.getBitsPerPixel(type));
                Stack stack = new Stack();
                int compression = this.getSource().readInt();
                stack.setCompression(this.getCompression(compression));
                this.getSource().skipBytes(4);
                int lengthOfName = this.getSource().readInt();
                int lengthOfDescription = this.getSource().readInt();
                this.getSource().skipBytes(8);
                long lengthOfData = this.getSource().readLong();
                stack.setLength(this.getLength(lengthOfData));
                long next = this.getSource().readLong();
                String name = this.getSource().readString(lengthOfName);
                iMeta.getTable().put("Name", name);
                String description = this.getSource().readString(lengthOfDescription);
                iMeta.getTable().put("Description", description);
                stack.setPosition(this.getSource().getFilePointer());
                ((Metadata)this.getMetadata()).getStacks().add(stack);
                if (fileVersion >= 1) {
                    this.getSource().skip(lengthOfData);
                    long footer = this.getSource().getFilePointer();
                    int offset = this.getSource().readInt();
                    ArrayList<Boolean> stepsPresent = new ArrayList<Boolean>();
                    for (int dimension = 0; dimension != 15; ++dimension) {
                        int present = this.getSource().readInt();
                        if (dimension >= numberOfDimensions) continue;
                        stepsPresent.add(present != 0);
                    }
                    ArrayList<Boolean> stepLabelsPresent = new ArrayList<Boolean>();
                    for (int dimension = 0; dimension != 15; ++dimension) {
                        int present = this.getSource().readInt();
                        if (dimension >= numberOfDimensions) continue;
                        stepLabelsPresent.add(present != 0);
                    }
                    this.getSource().seek(footer + (long)offset);
                    ArrayList<String> labels = new ArrayList<String>();
                    for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                        int length = this.getSource().readInt();
                        String label = this.getSource().readString(length);
                        labels.add(label);
                    }
                    iMeta.getTable().put("Labels", labels);
                    ArrayList steps = new ArrayList();
                    for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                        ArrayList<Double> list = new ArrayList<Double>();
                        if (((Boolean)stepsPresent.get(dimension)).booleanValue()) {
                            for (int position = 0; position != sizes[dimension]; ++position) {
                                double step = this.getSource().readDouble();
                                list.add(new Double(step));
                            }
                        }
                        steps.add(list);
                    }
                    iMeta.getTable().put("Steps", steps);
                    ArrayList stepLabels = new ArrayList();
                    for (int dimension = 0; dimension != numberOfDimensions; ++dimension) {
                        ArrayList<String> list = new ArrayList<String>();
                        if (((Boolean)stepLabelsPresent.get(dimension)).booleanValue()) {
                            for (int position = 0; position != sizes[dimension]; ++position) {
                                int length = this.getSource().readInt();
                                String label = this.getSource().readString(length);
                                list.add(label);
                            }
                        }
                        stepLabels.add(list);
                    }
                    iMeta.getTable().put("StepLabels", stepLabels);
                }
                return next;
            }
            throw new FormatException("Unsupported stack format");
        }

        private long getLength(long length) throws FormatException {
            if (length >= 0L) {
                return length;
            }
            throw new FormatException("Negative stack length on disk");
        }

        private boolean getCompression(int compression) throws FormatException {
            switch (compression) {
                case 0: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
            throw new FormatException("Unsupported compression " + compression);
        }
    }

    public static class Checker
    extends AbstractChecker {
        private static final int FILE_VERSION = 1;

        @Override
        public boolean suffixNecessary() {
            return false;
        }

        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(RandomAccessInputStream stream) throws IOException {
            int fileVersion = OBFUtilities.getFileVersion(stream);
            return fileVersion >= 0 && fileVersion <= 1;
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        private Frame currentInflatedFrame = new Frame();
        private Inflater inflater = new Inflater();
        private List<Stack> stacks = new ArrayList<Stack>();

        public Frame getCurrentInflatedFrame() {
            return this.currentInflatedFrame;
        }

        public void setCurrentInflatedFrame(Frame currentInflatedFrame) {
            this.currentInflatedFrame = currentInflatedFrame;
        }

        public Inflater getInflater() {
            return this.inflater;
        }

        public void setInflater(Inflater inflater) {
            this.inflater = inflater;
        }

        public List<Stack> getStacks() {
            return this.stacks;
        }

        public void setStacks(List<Stack> stacks) {
            this.stacks = stacks;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            iMeta.setPlanarAxisCount(2);
            iMeta.setIndexed(false);
            iMeta.setOrderCertain(false);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            this.stacks = new ArrayList<Stack>();
            this.currentInflatedFrame = new Frame();
            this.inflater = new Inflater();
            super.close(fileOnly);
        }
    }
}

