/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.HasColorTable;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import io.scif.io.RandomAccessInputStream;
import io.scif.util.FormatTools;
import java.io.IOException;
import java.util.Vector;
import net.imagej.axis.Axes;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Graphics Interchange Format")
public class GIFFormat
extends AbstractFormat {
    public static final String GIF_MAGIC_STRING = "GIF";

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"gif"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Graphics"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, long[] planeMin, long[] planeMax, SCIFIOConfig config) throws FormatException, IOException {
            byte[] buf = (byte[])plane.getData();
            Metadata meta = (Metadata)this.getMetadata();
            int xIndex = meta.get(imageIndex).getAxisIndex(Axes.X);
            int yIndex = meta.get(imageIndex).getAxisIndex(Axes.Y);
            plane.setColorTable(meta.getColorTable(0, 0L));
            FormatTools.checkPlaneForReading(meta, imageIndex, planeIndex, buf.length, planeMin, planeMax);
            int x = (int)planeMin[xIndex];
            int y = (int)planeMin[yIndex];
            int w = (int)planeMax[xIndex];
            int h = (int)planeMax[yIndex];
            int[] act = meta.getColorTables().get((int)planeIndex);
            byte[] b = meta.getImages().get((int)planeIndex);
            if (planeIndex > 0L && meta.isTransparency()) {
                byte[] prev = meta.getImages().get((int)planeIndex - 1);
                int idx = meta.getTransIndex();
                if (idx >= 127) {
                    idx = 0;
                }
                for (int i = 0; i < b.length; ++i) {
                    if ((act[b[i] & 0xFF] & 0xFFFFFF) != idx) continue;
                    b[i] = prev[i];
                }
                meta.getImages().setElementAt(b, (int)planeIndex);
            }
            for (int row = 0; row < h; ++row) {
                System.arraycopy(b, (row + y) * (int)meta.get(imageIndex).getAxisLength(Axes.X) + x, buf, row * w, w);
            }
            return plane;
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        private static final int IMAGE_SEPARATOR = 44;
        private static final int EXTENSION = 33;
        private static final int END = 59;
        private static final int GRAPHICS = 249;
        private static final int MAX_STACK_SIZE = 4096;

        @Override
        protected void typedParse(RandomAccessInputStream stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            this.log().info((Object)"Verifying GIF format");
            stream.order(true);
            meta.setImages(new Vector<byte[]>());
            meta.setColorTables(new Vector<int[]>());
            String ident = this.getSource().readString(6);
            if (!ident.startsWith(GIFFormat.GIF_MAGIC_STRING)) {
                throw new FormatException("Not a valid GIF file.");
            }
            this.log().info((Object)"Reading dimensions");
            meta.createImageMetadata(1);
            ImageMetadata iMeta = meta.get(0);
            iMeta.setAxisLength(Axes.X, (long)stream.readShort());
            iMeta.setAxisLength(Axes.Y, (long)stream.readShort());
            iMeta.setAxisLength(Axes.TIME, 0L);
            int packed = stream.read() & 0xFF;
            boolean gctFlag = (packed & 0x80) != 0;
            int gctSize = 2 << (packed & 7);
            stream.skipBytes(2);
            meta.getTable().put("Global lookup table size", gctSize);
            if (gctFlag) {
                meta.setGct(this.readLut(gctSize));
            }
            this.log().info((Object)"Reading data blocks");
            boolean done = false;
            while (!done) {
                int code = stream.read() & 0xFF;
                block0 : switch (code) {
                    case 44: {
                        this.readImageBlock();
                        break;
                    }
                    case 33: {
                        code = stream.read() & 0xFF;
                        switch (code) {
                            case 249: {
                                stream.skipBytes(1);
                                packed = stream.read() & 0xFF;
                                meta.setDispose((packed & 0x1C) >> 1);
                                meta.setTransparency((packed & 1) != 0);
                                stream.skipBytes(2);
                                meta.setTransIndex(stream.read() & 0xFF);
                                stream.skipBytes(1);
                                break block0;
                            }
                        }
                        if (this.readBlock() == -1) {
                            done = true;
                            break;
                        }
                        this.skipBlocks();
                        break;
                    }
                    case 59: {
                        done = true;
                    }
                }
            }
            meta.setAct(meta.getColorTables().get(0));
        }

        private void skipBlocks() throws IOException {
            int check = 0;
            do {
                check = this.readBlock();
            } while (((Metadata)this.getMetadata()).getBlockSize() > 0 && check != -1);
        }

        private void readImageBlock() throws FormatException, IOException {
            ((Metadata)this.getMetadata()).setIx(this.getSource().readShort());
            ((Metadata)this.getMetadata()).setIy(this.getSource().readShort());
            ((Metadata)this.getMetadata()).setIw(this.getSource().readShort());
            ((Metadata)this.getMetadata()).setIh(this.getSource().readShort());
            int packed = this.getSource().read();
            boolean lctFlag = (packed & 0x80) != 0;
            ((Metadata)this.getMetadata()).setInterlace((packed & 0x40) != 0);
            int lctSize = 2 << (packed & 7);
            ((Metadata)this.getMetadata()).setAct(lctFlag ? this.readLut(lctSize) : ((Metadata)this.getMetadata()).getGct());
            if (((Metadata)this.getMetadata()).getAct() == null) {
                throw new FormatException("Color table not found.");
            }
            int save = 0;
            if (((Metadata)this.getMetadata()).isTransparency()) {
                save = ((Metadata)this.getMetadata()).getAct()[((Metadata)this.getMetadata()).getTransIndex()];
                ((Metadata)this.getMetadata()).getAct()[((Metadata)this.getMetadata()).getTransIndex()] = 0;
            }
            this.decodeImageData();
            this.skipBlocks();
            ((Metadata)this.getMetadata()).get(0).setAxisLength(Axes.TIME, ((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.TIME) + 1L);
            if (((Metadata)this.getMetadata()).isTransparency()) {
                ((Metadata)this.getMetadata()).getAct()[((Metadata)this.getMetadata()).getTransIndex()] = save;
            }
            ((Metadata)this.getMetadata()).setLastDispose(((Metadata)this.getMetadata()).getDispose());
        }

        private void decodeImageData() throws IOException {
            int nullCode = -1;
            int npix = ((Metadata)this.getMetadata()).getIw() * ((Metadata)this.getMetadata()).getIh();
            byte[] pixels = ((Metadata)this.getMetadata()).getPixels();
            if (pixels == null || pixels.length < npix) {
                pixels = new byte[npix];
            }
            short[] prefix = ((Metadata)this.getMetadata()).getPrefix();
            byte[] suffix = ((Metadata)this.getMetadata()).getSuffix();
            byte[] pixelStack = ((Metadata)this.getMetadata()).getPixelStack();
            if (prefix == null) {
                prefix = new short[4096];
            }
            if (suffix == null) {
                suffix = new byte[4096];
            }
            if (pixelStack == null) {
                pixelStack = new byte[4097];
            }
            ((Metadata)this.getMetadata()).setPrefix(prefix);
            ((Metadata)this.getMetadata()).setSuffix(suffix);
            ((Metadata)this.getMetadata()).setPixelStack(pixelStack);
            int dataSize = this.getSource().read() & 0xFF;
            int clear = 1 << dataSize;
            int eoi = clear + 1;
            int available = clear + 2;
            int oldCode = -1;
            int codeSize = dataSize + 1;
            int codeMask = (1 << codeSize) - 1;
            int code = 0;
            int inCode = 0;
            for (code = 0; code < clear; ++code) {
                prefix[code] = 0;
                suffix[code] = (byte)code;
            }
            int datum = 0;
            int first = 0;
            int top = 0;
            int pi = 0;
            int bi = 0;
            int bits = 0;
            int count = 0;
            int i = 0;
            i = 0;
            while (i < npix) {
                if (top == 0) {
                    if (bits < codeSize) {
                        if (count == 0) {
                            count = this.readBlock();
                            if (count <= 0) break;
                            bi = 0;
                        }
                        datum += (((Metadata)this.getMetadata()).getdBlock()[bi] & 0xFF) << bits;
                        bits += 8;
                        ++bi;
                        --count;
                        continue;
                    }
                    code = datum & codeMask;
                    datum >>= codeSize;
                    bits -= codeSize;
                    if (code > available || code == eoi) break;
                    if (code == clear) {
                        codeSize = dataSize + 1;
                        codeMask = (1 << codeSize) - 1;
                        available = clear + 2;
                        oldCode = -1;
                        continue;
                    }
                    if (oldCode == -1) {
                        pixelStack[top++] = suffix[code];
                        oldCode = code;
                        first = code;
                        continue;
                    }
                    inCode = code;
                    if (code == available) {
                        pixelStack[top++] = (byte)first;
                        code = oldCode;
                    }
                    while (code > clear) {
                        pixelStack[top++] = suffix[code];
                        code = prefix[code];
                    }
                    first = suffix[code] & 0xFF;
                    if (available >= 4096) break;
                    pixelStack[top++] = (byte)first;
                    prefix[available] = (short)oldCode;
                    suffix[available] = (byte)first;
                    if ((++available & codeMask) == 0 && available < 4096) {
                        ++codeSize;
                        codeMask += available;
                    }
                    oldCode = inCode;
                }
                pixels[pi++] = pixelStack[--top];
                ++i;
            }
            for (i = pi; i < npix; ++i) {
                pixels[i] = 0;
            }
            ((Metadata)this.getMetadata()).setPixels(pixels);
            this.setPixels();
        }

        private void setPixels() {
            byte[] dest = new byte[(int)(((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.X) * ((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.Y))];
            long lastImage = -1L;
            if (((Metadata)this.getMetadata()).getLastDispose() > 0) {
                long n;
                if (((Metadata)this.getMetadata()).getLastDispose() == 3 && (n = ((Metadata)this.getMetadata()).get(0).getPlaneCount() - 2L) > 0L) {
                    lastImage = n - 1L;
                }
                if (lastImage != -1L) {
                    byte[] prev = ((Metadata)this.getMetadata()).getImages().get((int)lastImage);
                    System.arraycopy(prev, 0, dest, 0, (int)(((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.X) * ((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.Y)));
                }
            }
            int pass = 1;
            int inc = 8;
            int iline = 0;
            for (int i = 0; i < ((Metadata)this.getMetadata()).getIh(); ++i) {
                int line = i;
                if (((Metadata)this.getMetadata()).isInterlace()) {
                    if (iline >= ((Metadata)this.getMetadata()).getIh()) {
                        switch (++pass) {
                            case 2: {
                                iline = 4;
                                break;
                            }
                            case 3: {
                                iline = 2;
                                inc = 4;
                                break;
                            }
                            case 4: {
                                iline = 1;
                                inc = 2;
                            }
                        }
                    }
                    line = iline;
                    iline += inc;
                }
                if ((long)(line += ((Metadata)this.getMetadata()).getIy()) >= ((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.Y)) continue;
                int k = line * (int)((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.X);
                int dx = k + ((Metadata)this.getMetadata()).getIx();
                int dlim = dx + ((Metadata)this.getMetadata()).getIw();
                if ((long)k + ((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.X) < (long)dlim) {
                    dlim = k + (int)((Metadata)this.getMetadata()).get(0).getAxisLength(Axes.X);
                }
                int sx = i * ((Metadata)this.getMetadata()).getIw();
                while (dx < dlim) {
                    int index = ((Metadata)this.getMetadata()).getPixels()[sx++] & 0xFF;
                    dest[dx++] = (byte)index;
                }
            }
            ((Metadata)this.getMetadata()).getColorTables().add(((Metadata)this.getMetadata()).getAct());
            ((Metadata)this.getMetadata()).getImages().add(dest);
        }

        private int readBlock() throws IOException {
            int n;
            if (this.getSource().getFilePointer() == this.getSource().length()) {
                return -1;
            }
            ((Metadata)this.getMetadata()).setBlockSize(this.getSource().read() & 0xFF);
            if (((Metadata)this.getMetadata()).getBlockSize() > 0) {
                try {
                    int count;
                    for (n = 0; n < ((Metadata)this.getMetadata()).getBlockSize() && (count = this.getSource().read(((Metadata)this.getMetadata()).getdBlock(), n, ((Metadata)this.getMetadata()).getBlockSize() - n)) != -1; n += count) {
                    }
                }
                catch (IOException e) {
                    this.log().trace((Object)"Truncated block", (Throwable)e);
                }
            }
            return n;
        }

        private int[] readLut(int size) throws FormatException {
            int nbytes = 3 * size;
            byte[] c = new byte[nbytes];
            int n = 0;
            try {
                n = this.getSource().read(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (n < nbytes) {
                throw new FormatException("Color table not found");
            }
            int[] lut = new int[256];
            int j = 0;
            for (int i = 0; i < size; ++i) {
                int r = c[j++] & 0xFF;
                int g = c[j++] & 0xFF;
                int b = c[j++] & 0xFF;
                lut[i] = 0xFF000000 | r << 16 | g << 8 | b;
            }
            return lut;
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean isFormat(RandomAccessInputStream in) throws IOException {
            int blockLen = GIFFormat.GIF_MAGIC_STRING.length();
            if (!FormatTools.validStream(in, blockLen, false)) {
                return false;
            }
            return in.readString(blockLen).startsWith(GIFFormat.GIF_MAGIC_STRING);
        }
    }

    public static class Metadata
    extends AbstractMetadata
    implements HasColorTable {
        private ColorTable8 cachedTable;
        private int[] gct;
        private int[] act;
        private boolean interlace;
        private int ix;
        private int iy;
        private int iw;
        private int ih;
        private byte[] dBlock = new byte[256];
        private int blockSize = 0;
        private int dispose = 0;
        private int lastDispose = 0;
        private boolean transparency = false;
        private int transIndex;
        private short[] prefix;
        private byte[] suffix;
        private byte[] pixelStack;
        private byte[] pixels;
        private Vector<byte[]> images;
        private Vector<int[]> colorTables;

        public int[] getGct() {
            return this.gct;
        }

        public void setGct(int[] gct) {
            this.gct = gct;
        }

        public int[] getAct() {
            return this.act;
        }

        public void setAct(int[] act) {
            this.act = act;
        }

        public boolean isInterlace() {
            return this.interlace;
        }

        public void setInterlace(boolean interlace) {
            this.interlace = interlace;
        }

        public int getIx() {
            return this.ix;
        }

        public void setIx(int ix) {
            this.ix = ix;
        }

        public int getIy() {
            return this.iy;
        }

        public void setIy(int iy) {
            this.iy = iy;
        }

        public int getIw() {
            return this.iw;
        }

        public void setIw(int iw) {
            this.iw = iw;
        }

        public int getIh() {
            return this.ih;
        }

        public void setIh(int ih) {
            this.ih = ih;
        }

        public byte[] getdBlock() {
            return this.dBlock;
        }

        public void setdBlock(byte[] dBlock) {
            this.dBlock = dBlock;
        }

        public int getBlockSize() {
            return this.blockSize;
        }

        public void setBlockSize(int blockSize) {
            this.blockSize = blockSize;
        }

        public int getDispose() {
            return this.dispose;
        }

        public void setDispose(int dispose) {
            this.dispose = dispose;
        }

        public int getLastDispose() {
            return this.lastDispose;
        }

        public void setLastDispose(int lastDispose) {
            this.lastDispose = lastDispose;
        }

        public boolean isTransparency() {
            return this.transparency;
        }

        public void setTransparency(boolean transparency) {
            this.transparency = transparency;
        }

        public int getTransIndex() {
            return this.transIndex;
        }

        public void setTransIndex(int transIndex) {
            this.transIndex = transIndex;
        }

        public short[] getPrefix() {
            return this.prefix;
        }

        public void setPrefix(short[] prefix) {
            this.prefix = prefix;
        }

        public byte[] getSuffix() {
            return this.suffix;
        }

        public void setSuffix(byte[] suffix) {
            this.suffix = suffix;
        }

        public byte[] getPixelStack() {
            return this.pixelStack;
        }

        public void setPixelStack(byte[] pixelStack) {
            this.pixelStack = pixelStack;
        }

        public byte[] getPixels() {
            return this.pixels;
        }

        public void setPixels(byte[] pixels) {
            this.pixels = pixels;
        }

        public Vector<byte[]> getImages() {
            return this.images;
        }

        public void setImages(Vector<byte[]> images) {
            this.images = images;
        }

        public Vector<int[]> getColorTables() {
            return this.colorTables;
        }

        public void setColorTables(Vector<int[]> colorTables) {
            this.colorTables = colorTables;
        }

        @Override
        public void populateImageMetadata() {
            ImageMetadata iMeta = this.get(0);
            iMeta.setAxisLength(Axes.CHANNEL, 1L);
            iMeta.setAxisTypes(Axes.CHANNEL, Axes.X, Axes.Y, Axes.TIME);
            iMeta.setPlanarAxisCount(3);
            iMeta.setLittleEndian(true);
            iMeta.setMetadataComplete(true);
            iMeta.setIndexed(true);
            iMeta.setFalseColor(false);
            iMeta.setPixelType(1);
        }

        @Override
        public void close(boolean fileOnly) throws IOException {
            int length = this.dBlock.length;
            super.close(fileOnly);
            if (!fileOnly) {
                this.transparency = false;
                this.interlace = false;
                this.blockSize = 0;
                this.ih = 0;
                this.iw = 0;
                this.iy = 0;
                this.ix = 0;
                this.transIndex = 0;
                this.lastDispose = 0;
                this.dispose = 0;
                this.gct = this.act;
                this.prefix = null;
                this.pixels = null;
                this.pixelStack = null;
                this.suffix = null;
                this.images = null;
                this.colorTables = null;
                this.dBlock = new byte[length];
            }
        }

        @Override
        public ColorTable getColorTable(int imageIndex, long planeIndex) {
            if (this.cachedTable == null) {
                byte[][] table = new byte[3][this.act.length];
                for (int i = 0; i < this.act.length; ++i) {
                    table[0][i] = (byte)(this.act[i] >> 16 & 0xFF);
                    table[1][i] = (byte)(this.act[i] >> 8 & 0xFF);
                    table[2][i] = (byte)(this.act[i] & 0xFF);
                }
                this.cachedTable = new ColorTable8(table);
            }
            return this.cachedTable;
        }
    }
}

