/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.LapackInfo;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DMatrixQrd {
    private static final BLAS _blas = BLAS.getInstance();
    private static final LAPACK _lapack = LAPACK.getInstance();
    int _m;
    int _n;
    int _k;
    double[] _qr;
    double[] _tau;
    double[] _work;
    int _lwork;

    public DMatrixQrd(DMatrix a) {
        Check.argument(a.getM() >= a.getN(), "m >= n");
        this._m = a.getM();
        this._n = a.getN();
        this._k = ArrayMath.min(this._m, this._n);
        this._qr = a.getPackedColumns();
        this._tau = new double[this._k];
        this._work = new double[1];
        LapackInfo li = new LapackInfo();
        _lapack.dgeqrf(this._m, this._n, this._qr, this._m, this._tau, this._work, -1, (intW)li);
        li.check("dgeqrf");
        this._lwork = (int)this._work[0];
        this._work = new double[this._lwork];
        _lapack.dgeqrf(this._m, this._n, this._qr, this._m, this._tau, this._work, this._lwork, (intW)li);
        li.check("dgeqrf");
    }

    public boolean isFullRank() {
        for (int j = 0; j < this._n; ++j) {
            if (this._qr[j + j * this._m] != 0.0) continue;
            return false;
        }
        return true;
    }

    public DMatrix getQ() {
        double[] q = ArrayMath.copy(this._qr);
        LapackInfo li = new LapackInfo();
        _lapack.dorgqr(this._m, this._n, this._k, q, this._m, this._tau, this._work, this._lwork, (intW)li);
        li.check("dorgqr");
        return new DMatrix(this._m, this._n, q);
    }

    public DMatrix getR() {
        double[] r = new double[this._n * this._n];
        for (int j = 0; j < this._n; ++j) {
            for (int i = 0; i <= j; ++i) {
                r[i + j * this._n] = this._qr[i + j * this._m];
            }
        }
        return new DMatrix(this._n, this._n, r);
    }

    public DMatrix solve(DMatrix b) {
        Check.argument(b.getM() == this._m, "A and B have the same number of rows");
        Check.state(this.isFullRank(), "A is of full rank");
        int nrhs = b.getN();
        DMatrix c = new DMatrix(b);
        double[] ca = c.getArray();
        double[] work = new double[1];
        LapackInfo li = new LapackInfo();
        _lapack.dormqr("L", "T", this._m, nrhs, this._k, this._qr, this._m, this._tau, ca, this._m, work, -1, (intW)li);
        li.check("dormqr");
        int lwork = (int)work[0];
        work = new double[lwork];
        _lapack.dormqr("L", "T", this._m, nrhs, this._k, this._qr, this._m, this._tau, ca, this._m, work, lwork, (intW)li);
        li.check("dormqr");
        _blas.dtrsm("L", "U", "N", "N", this._n, nrhs, 1.0, this._qr, this._m, ca, this._m);
        DMatrix x = c.get(0, this._n - 1, null);
        return x;
    }
}

