/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.lut;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.imagej.Dataset;
import net.imagej.DatasetService;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.display.DatasetView;
import net.imagej.display.ImageDisplay;
import net.imagej.display.ImageDisplayService;
import net.imagej.lut.LUTService;
import net.imagej.table.ResultsTable;
import net.imagej.table.TableLoader;
import net.imagej.util.AppUtils;
import net.imglib2.RandomAccess;
import net.imglib2.display.ColorTable;
import net.imglib2.display.ColorTable8;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import org.scijava.MenuEntry;
import org.scijava.MenuPath;
import org.scijava.command.CommandInfo;
import org.scijava.display.DisplayService;
import org.scijava.log.LogService;
import org.scijava.module.ModuleInfo;
import org.scijava.module.ModuleService;
import org.scijava.object.LazyObjects;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class, priority=100.0)
public class DefaultLUTService
extends AbstractService
implements LUTService {
    private static final int RAMP_WIDTH = 256;
    private static final int RAMP_HEIGHT = 32;
    private static final int MAX_LUT_LENGTH = 655360;
    @Parameter
    private LogService logService;
    @Parameter
    private ModuleService moduleService;
    @Parameter
    private DatasetService datasetService;
    @Parameter
    private DisplayService displayService;
    @Parameter
    private ImageDisplayService imageDisplayService;

    @Override
    public Map<String, URL> findLUTs() {
        return AppUtils.findResources(".*\\.lut$", "luts");
    }

    @Override
    public boolean isLUT(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(".lut");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColorTable loadLUT(File file) throws IOException {
        ColorTable colorTable;
        FileInputStream is = new FileInputStream(file);
        int length = (int)Math.min(file.length(), Integer.MAX_VALUE);
        try {
            colorTable = this.loadLUT(is, length);
        }
        finally {
            is.close();
        }
        return colorTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColorTable loadLUT(URL url) throws IOException {
        ColorTable colorTable;
        try (InputStream is = url.openStream();){
            colorTable = this.loadLUT(is);
        }
        return colorTable;
    }

    @Override
    public ColorTable loadLUT(InputStream is) throws IOException {
        int r;
        byte[] bytes = new byte[655360];
        int length = 0;
        while ((r = is.read(bytes, length, bytes.length - length)) >= 0) {
            length += r;
        }
        return this.loadLUT(new ByteArrayInputStream(bytes, 0, length), length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColorTable loadLUT(InputStream is, int length) throws IOException {
        ColorTable lut = null;
        BufferedInputStream bufferedStr = null;
        try {
            bufferedStr = new BufferedInputStream(is);
            bufferedStr.mark(length);
            if (length > 768) {
                lut = this.nihImageBinaryLUT(bufferedStr);
                bufferedStr.reset();
            }
            if (lut == null && (length == 0 || length == 768 || length == 970)) {
                lut = this.legacyBinaryLUT(bufferedStr);
                bufferedStr.reset();
            }
            if (lut == null && length > 768) {
                lut = this.legacyTextLUT(bufferedStr);
                bufferedStr.reset();
            }
            if (lut == null) {
                lut = this.modernLUT(bufferedStr);
            }
        }
        finally {
            if (bufferedStr != null) {
                bufferedStr.close();
            }
            is.close();
        }
        return lut;
    }

    @Override
    public Dataset createDataset(String title, ColorTable colorTable) {
        Dataset dataset = this.datasetService.create(new UnsignedByteType(), new long[]{256L, 32L}, title, new AxisType[]{Axes.X, Axes.Y});
        this.rampFill(dataset);
        if (dataset.getColorTableCount() == 0) {
            dataset.initializeColorTables(1);
        }
        dataset.setColorTable(colorTable, 0);
        return dataset;
    }

    @Override
    public void applyLUT(ColorTable colorTable, ImageDisplay display) {
        DatasetView view = this.imageDisplayService.getActiveDatasetView(display);
        if (view == null) {
            return;
        }
        int channel = view.getIntPosition(Axes.CHANNEL);
        view.setColorTable(colorTable, channel);
        display.update();
    }

    public void initialize() {
        this.moduleService.getIndex().addLater((LazyObjects)new LazyObjects<ModuleInfo>(){

            public Collection<ModuleInfo> get() {
                Map<String, URL> luts = DefaultLUTService.this.findLUTs();
                ArrayList<ModuleInfo> modules = new ArrayList<ModuleInfo>();
                for (String key : luts.keySet()) {
                    modules.add(DefaultLUTService.this.createInfo(key, luts.get(key)));
                }
                return modules;
            }
        });
    }

    private ModuleInfo createInfo(String key, URL url) {
        String[] subPaths = key.split("/");
        MenuPath menuPath = new MenuPath();
        menuPath.add((Object)new MenuEntry("Image"));
        menuPath.add((Object)new MenuEntry("Lookup Tables"));
        for (int i = 0; i < subPaths.length - 1; ++i) {
            menuPath.add((Object)new MenuEntry(subPaths[i]));
        }
        MenuEntry leaf = new MenuEntry(this.tableName(subPaths[subPaths.length - 1]));
        leaf.setWeight(50.0);
        menuPath.add((Object)leaf);
        HashMap<String, URL> presets = new HashMap<String, URL>();
        presets.put("tableURL", url);
        CommandInfo info = new CommandInfo("net.imagej.plugins.commands.misc.ApplyLookupTable");
        info.setPresets(presets);
        info.setMenuPath(menuPath);
        return info;
    }

    private String tableName(String filename) {
        int ext = filename.lastIndexOf(".lut");
        return filename.substring(0, ext);
    }

    private ColorTable modernLUT(InputStream is) throws IOException {
        return null;
    }

    private ColorTable nihImageBinaryLUT(InputStream is) throws IOException {
        return this.oldBinaryLUT(false, is);
    }

    private ColorTable legacyBinaryLUT(InputStream is) throws IOException {
        return this.oldBinaryLUT(true, is);
    }

    private ColorTable legacyTextLUT(BufferedInputStream is) throws IOException {
        ResultsTable table = new TableLoader().valuesFromTextFile(is);
        if (table == null) {
            return null;
        }
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        int cols = table.getColumnCount();
        int rows = table.getRowCount();
        if (cols < 3 || cols > 4 || rows < 256 || rows > 258) {
            return null;
        }
        int x = cols == 4 ? 1 : 0;
        int y = rows > 256 ? 1 : 0;
        for (int r = 0; r < 256; ++r) {
            reds[r] = (byte)table.getValue(x + 0, y + r);
            greens[r] = (byte)table.getValue(x + 1, y + r);
            blues[r] = (byte)table.getValue(x + 2, y + r);
        }
        return new ColorTable8(reds, greens, blues);
    }

    private ColorTable oldBinaryLUT(boolean raw, InputStream is) throws IOException {
        DataInputStream f = new DataInputStream(is);
        int nColors = 256;
        if (!raw) {
            int id = f.readInt();
            if (id != 1229147980) {
                return null;
            }
            f.readShort();
            nColors = f.readShort();
            f.readShort();
            f.readShort();
            f.readLong();
            f.readLong();
            f.readInt();
        }
        byte[] reds = new byte[256];
        byte[] greens = new byte[256];
        byte[] blues = new byte[256];
        f.read(reds, 0, nColors);
        f.read(greens, 0, nColors);
        f.read(blues, 0, nColors);
        if (nColors < 256) {
            this.interpolate(reds, greens, blues, nColors);
        }
        return new ColorTable8(reds, greens, blues);
    }

    private void interpolate(byte[] reds, byte[] greens, byte[] blues, int nColors) {
        byte[] r = new byte[nColors];
        byte[] g = new byte[nColors];
        byte[] b = new byte[nColors];
        System.arraycopy(reds, 0, r, 0, nColors);
        System.arraycopy(greens, 0, g, 0, nColors);
        System.arraycopy(blues, 0, b, 0, nColors);
        double scale = (double)nColors / 256.0;
        for (int i = 0; i < 256; ++i) {
            int i1 = (int)((double)i * scale);
            int i2 = i1 + 1;
            if (i2 == nColors) {
                i2 = nColors - 1;
            }
            double fraction = (double)i * scale - (double)i1;
            reds[i] = (byte)((1.0 - fraction) * (double)(r[i1] & 0xFF) + fraction * (double)(r[i2] & 0xFF));
            greens[i] = (byte)((1.0 - fraction) * (double)(g[i1] & 0xFF) + fraction * (double)(g[i2] & 0xFF));
            blues[i] = (byte)((1.0 - fraction) * (double)(b[i1] & 0xFF) + fraction * (double)(b[i2] & 0xFF));
        }
    }

    private void rampFill(Dataset dataset) {
        RandomAccess<RealType<?>> accessor = dataset.getImgPlus().randomAccess();
        for (int x = 0; x < 256; ++x) {
            accessor.setPosition(x, 0);
            for (int y = 0; y < 32; ++y) {
                accessor.setPosition(y, 1);
                ((RealType)accessor.get()).setReal(x);
            }
        }
    }
}

