/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.jupyter.kernel.evaluator;

import com.twosigma.beaker.autocomplete.AutocompleteResult;
import com.twosigma.beaker.evaluator.Evaluator;
import com.twosigma.beaker.jvm.object.SimpleEvaluationObject;
import com.twosigma.jupyter.KernelParameters;
import java.io.IOException;
import java.util.ArrayList;
import javax.script.ScriptEngine;
import org.scijava.Context;
import org.scijava.jupyter.kernel.evaluator.Worker;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.script.ScriptLanguage;
import org.scijava.script.ScriptService;
import org.scijava.thread.ThreadService;

public class ScijavaEvaluator
implements Evaluator {
    @Parameter
    private LogService log;
    @Parameter
    private transient ScriptService scriptService;
    @Parameter
    private ThreadService threadService;
    @Parameter
    Context context;
    private String languageUsed;
    private ScriptLanguage scriptLanguage;
    private ScriptEngine scriptEngine;
    protected String shellId;
    protected String sessionId;

    public ScijavaEvaluator(Context context, String shellId, String sessionId, String languageName) {
        context.inject(this);
        this.shellId = shellId;
        this.sessionId = sessionId;
        this.setLanguage(languageName);
    }

    public void setShellOptions(KernelParameters kp) throws IOException {
        this.log.debug("Set shell options : " + kp);
    }

    public AutocompleteResult autocomplete(String code, int i) {
        ArrayList<String> matches = new ArrayList<String>();
        matches.add("Autocompletion does not work yet.");
        int startIndex = 0;
        AutocompleteResult ac = new AutocompleteResult(matches, startIndex);
        return ac;
    }

    public void killAllThreads() {
        this.log.debug("Kill All Threads");
        System.exit(0);
    }

    public void startWorker() {
    }

    public void evaluate(SimpleEvaluationObject seo, String code) {
        Worker worker = new Worker(this.context, this.scriptEngine, this.scriptLanguage);
        worker.setup(seo, code);
        this.threadService.queue(worker);
    }

    public void exit() {
        this.log.debug("Exiting DefaultEvaluator");
        System.exit(0);
    }

    private void setLanguage(String languageName) {
        if (this.scriptService.getLanguageByName(languageName) == null) {
            this.log.error("Script Language for '" + languageName + "' not found.");
            System.exit(1);
        }
        this.languageUsed = languageName;
        this.scriptLanguage = this.scriptService.getLanguageByName(languageName);
        this.scriptEngine = this.scriptLanguage.getScriptEngine();
        this.log.debug("Script Language found for '" + this.languageUsed + "'");
    }

    public ScriptLanguage getScriptLanguage() {
        return this.scriptLanguage;
    }

    public String getLanguage() {
        return this.languageUsed;
    }
}

