/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripting.renjin;

import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.ExternalPtr;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.Symbol;

public final class RenjinUtils {
    public static Object getJavaValue(SEXP value) {
        if (value == null || value == Symbol.UNBOUND_VALUE) {
            return null;
        }
        try {
            if (value instanceof IntArrayVector) {
                int[] iArray = ((IntArrayVector)value).toIntArray();
                return iArray.length == 1 ? (Object)iArray[0] : iArray;
            }
            if (value instanceof DoubleArrayVector) {
                double[] dArray = ((DoubleArrayVector)value).toDoubleArray();
                return dArray.length == 1 ? (Object)dArray[0] : dArray;
            }
            if (value instanceof LogicalArrayVector) {
                int[] lArray = ((LogicalArrayVector)value).toIntArray();
                return lArray.length == 1 ? (Object)lArray[0] : lArray;
            }
            if (value instanceof StringArrayVector) {
                String[] sArray = ((StringArrayVector)value).toArray();
                return sArray.length == 1 ? sArray[0] : sArray;
            }
            if (value instanceof ExternalPtr) {
                return ((ExternalPtr)value).getInstance();
            }
            return value;
        }
        catch (Exception exc) {
            return value.toString();
        }
    }
}

