/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.util.Collection;
import mpicbg.models.AbstractAffineModel3D;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleBoundable;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.PointMatch;
import mpicbg.models.TranslationModel3D;
import mpicbg.util.Matrix3x3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AffineModel3D
extends AbstractAffineModel3D<AffineModel3D>
implements InvertibleBoundable {
    private static final long serialVersionUID = 4591403097787254013L;
    protected static final int MIN_NUM_MATCHES = 4;
    protected double m00 = 1.0;
    protected double m01 = 0.0;
    protected double m02 = 0.0;
    protected double m03 = 0.0;
    protected double m10 = 0.0;
    protected double m11 = 1.0;
    protected double m12 = 0.0;
    protected double m13 = 0.0;
    protected double m20 = 0.0;
    protected double m21 = 0.0;
    protected double m22 = 1.0;
    protected double m23 = 0.0;
    protected double i00 = 1.0;
    protected double i01 = 0.0;
    protected double i02 = 0.0;
    protected double i03 = 0.0;
    protected double i10 = 0.0;
    protected double i11 = 1.0;
    protected double i12 = 0.0;
    protected double i13 = 0.0;
    protected double i20 = 0.0;
    protected double i21 = 0.0;
    protected double i22 = 1.0;
    protected double i23 = 0.0;
    protected boolean isInvertible = true;

    @Override
    public double[] getMatrix(double[] m) {
        double[] a = m == null || m.length != 12 ? new double[12] : m;
        a[0] = this.m00;
        a[1] = this.m01;
        a[2] = this.m02;
        a[3] = this.m03;
        a[4] = this.m10;
        a[5] = this.m11;
        a[6] = this.m12;
        a[7] = this.m13;
        a[8] = this.m20;
        a[9] = this.m21;
        a[10] = this.m22;
        a[11] = this.m23;
        return a;
    }

    @Override
    public final int getMinNumMatches() {
        return 4;
    }

    @Override
    public final double[] apply(double[] l) {
        double[] transformed = (double[])l.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInPlace(double[] l) {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.m00 + l1 * this.m01 + l[2] * this.m02 + this.m03;
        l[1] = l0 * this.m10 + l1 * this.m11 + l[2] * this.m12 + this.m13;
        l[2] = l0 * this.m20 + l1 * this.m21 + l[2] * this.m22 + this.m23;
    }

    @Override
    public final double[] applyInverse(double[] l) throws NoninvertibleModelException {
        double[] transformed = (double[])l.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public final void applyInverseInPlace(double[] l) throws NoninvertibleModelException {
        assert (l.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        if (!this.isInvertible) {
            throw new NoninvertibleModelException("Model not invertible.");
        }
        double l0 = l[0];
        double l1 = l[1];
        l[0] = l0 * this.i00 + l1 * this.i01 + l[2] * this.i02 + this.i03;
        l[1] = l0 * this.i10 + l1 * this.i11 + l[2] * this.i12 + this.i13;
        l[2] = l0 * this.i20 + l1 * this.i21 + l[2] * this.i22 + this.i23;
    }

    @Override
    public final void fit(double[][] p, double[][] q, double[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 3 && q.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 4) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d affine model, at least " + 4 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double pcz = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double qcz = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] pZ = p[2];
            double[] qX = q[0];
            double[] qY = q[1];
            double[] qZ = q[2];
            double ww = w[i];
            ws += ww;
            pcx += ww * pX[i];
            pcy += ww * pY[i];
            pcz += ww * pZ[i];
            qcx += ww * qX[i];
            qcy += ww * qY[i];
            qcz += ww * qZ[i];
        }
        pcx /= ws;
        pcy /= ws;
        pcz /= ws;
        qcx /= ws;
        qcy /= ws;
        qcz /= ws;
        double b22 = 0.0;
        double b21 = 0.0;
        double b20 = 0.0;
        double b12 = 0.0;
        double b11 = 0.0;
        double b10 = 0.0;
        double b02 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a22 = 0.0;
        double a12 = 0.0;
        double a11 = 0.0;
        double a02 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (int i = 0; i < l; ++i) {
            double[] pX = p[0];
            double[] pY = p[1];
            double[] pZ = p[2];
            double[] qX = q[0];
            double[] qY = q[1];
            double[] qZ = q[2];
            double ww = w[i];
            double px = pX[i] - pcx;
            double py = pY[i] - pcy;
            double pz = pZ[i] - pcz;
            double qx = qX[i] - qcx;
            double qy = qY[i] - qcy;
            double qz = qZ[i] - qcz;
            a00 += ww * px * px;
            a01 += ww * px * py;
            a02 += ww * px * pz;
            a11 += ww * py * py;
            a12 += ww * py * pz;
            a22 += ww * pz * pz;
            b00 += ww * px * qx;
            b01 += ww * px * qy;
            b02 += ww * px * qz;
            b10 += ww * py * qx;
            b11 += ww * py * qy;
            b12 += ww * py * qz;
            b20 += ww * pz * qx;
            b21 += ww * pz * qy;
            b22 += ww * pz * qz;
        }
        double det = a00 * a11 * a22 + a01 * a12 * a02 + a02 * a01 * a12 - a02 * a11 * a02 - a12 * a12 * a00 - a22 * a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        double idet = 1.0 / det;
        double ai00 = (a11 * a22 - a12 * a12) * idet;
        double ai01 = (a02 * a12 - a01 * a22) * idet;
        double ai02 = (a01 * a12 - a02 * a11) * idet;
        double ai11 = (a00 * a22 - a02 * a02) * idet;
        double ai12 = (a02 * a01 - a00 * a12) * idet;
        double ai22 = (a00 * a11 - a01 * a01) * idet;
        this.m00 = ai00 * b00 + ai01 * b10 + ai02 * b20;
        this.m01 = ai01 * b00 + ai11 * b10 + ai12 * b20;
        this.m02 = ai02 * b00 + ai12 * b10 + ai22 * b20;
        this.m10 = ai00 * b01 + ai01 * b11 + ai02 * b21;
        this.m11 = ai01 * b01 + ai11 * b11 + ai12 * b21;
        this.m12 = ai02 * b01 + ai12 * b11 + ai22 * b21;
        this.m20 = ai00 * b02 + ai01 * b12 + ai02 * b22;
        this.m21 = ai01 * b02 + ai11 * b12 + ai12 * b22;
        this.m22 = ai02 * b02 + ai12 * b12 + ai22 * b22;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final void fit(float[][] p, float[][] q, float[] w) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        assert (p.length >= 3 && q.length >= 3) : "3d affine transformations can be applied to 3d points only.";
        assert (p[0].length == p[1].length && p[0].length == q[0].length && p[0].length == q[1].length && p[0].length == w.length) : "Array lengths do not match.";
        int l = p[0].length;
        if (l < 4) {
            throw new NotEnoughDataPointsException(l + " data points are not enough to estimate a 2d affine model, at least " + 4 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double pcz = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double qcz = 0.0;
        double ws = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] pZ = p[2];
            float[] qX = q[0];
            float[] qY = q[1];
            float[] qZ = q[2];
            double ww = w[i];
            ws += ww;
            pcx += ww * (double)pX[i];
            pcy += ww * (double)pY[i];
            pcz += ww * (double)pZ[i];
            qcx += ww * (double)qX[i];
            qcy += ww * (double)qY[i];
            qcz += ww * (double)qZ[i];
        }
        pcx /= ws;
        pcy /= ws;
        pcz /= ws;
        qcx /= ws;
        qcy /= ws;
        qcz /= ws;
        double b22 = 0.0;
        double b21 = 0.0;
        double b20 = 0.0;
        double b12 = 0.0;
        double b11 = 0.0;
        double b10 = 0.0;
        double b02 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a22 = 0.0;
        double a12 = 0.0;
        double a11 = 0.0;
        double a02 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (int i = 0; i < l; ++i) {
            float[] pX = p[0];
            float[] pY = p[1];
            float[] pZ = p[2];
            float[] qX = q[0];
            float[] qY = q[1];
            float[] qZ = q[2];
            double ww = w[i];
            double px = (double)pX[i] - pcx;
            double py = (double)pY[i] - pcy;
            double pz = (double)pZ[i] - pcz;
            double qx = (double)qX[i] - qcx;
            double qy = (double)qY[i] - qcy;
            double qz = (double)qZ[i] - qcz;
            a00 += ww * px * px;
            a01 += ww * px * py;
            a02 += ww * px * pz;
            a11 += ww * py * py;
            a12 += ww * py * pz;
            a22 += ww * pz * pz;
            b00 += ww * px * qx;
            b01 += ww * px * qy;
            b02 += ww * px * qz;
            b10 += ww * py * qx;
            b11 += ww * py * qy;
            b12 += ww * py * qz;
            b20 += ww * pz * qx;
            b21 += ww * pz * qy;
            b22 += ww * pz * qz;
        }
        double det = a00 * a11 * a22 + a01 * a12 * a02 + a02 * a01 * a12 - a02 * a11 * a02 - a12 * a12 * a00 - a22 * a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        double idet = 1.0 / det;
        double ai00 = (a11 * a22 - a12 * a12) * idet;
        double ai01 = (a02 * a12 - a01 * a22) * idet;
        double ai02 = (a01 * a12 - a02 * a11) * idet;
        double ai11 = (a00 * a22 - a02 * a02) * idet;
        double ai12 = (a02 * a01 - a00 * a12) * idet;
        double ai22 = (a00 * a11 - a01 * a01) * idet;
        this.m00 = ai00 * b00 + ai01 * b10 + ai02 * b20;
        this.m01 = ai01 * b00 + ai11 * b10 + ai12 * b20;
        this.m02 = ai02 * b00 + ai12 * b10 + ai22 * b20;
        this.m10 = ai00 * b01 + ai01 * b11 + ai02 * b21;
        this.m11 = ai01 * b01 + ai11 * b11 + ai12 * b21;
        this.m12 = ai02 * b01 + ai12 * b11 + ai22 * b21;
        this.m20 = ai00 * b02 + ai01 * b12 + ai02 * b22;
        this.m21 = ai01 * b02 + ai11 * b12 + ai12 * b22;
        this.m22 = ai02 * b02 + ai12 * b12 + ai22 * b22;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final <P extends PointMatch> void fit(Collection<P> matches) throws NotEnoughDataPointsException, IllDefinedDataPointsException {
        if (matches.size() < 4) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 2d affine model, at least " + 4 + " data points required.");
        }
        double pcx = 0.0;
        double pcy = 0.0;
        double pcz = 0.0;
        double qcx = 0.0;
        double qcy = 0.0;
        double qcz = 0.0;
        double ws = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            ws += w;
            pcx += w * p[0];
            pcy += w * p[1];
            pcz += w * p[2];
            qcx += w * q[0];
            qcy += w * q[1];
            qcz += w * q[2];
        }
        pcx /= ws;
        pcy /= ws;
        pcz /= ws;
        qcx /= ws;
        qcy /= ws;
        qcz /= ws;
        double b22 = 0.0;
        double b21 = 0.0;
        double b20 = 0.0;
        double b12 = 0.0;
        double b11 = 0.0;
        double b10 = 0.0;
        double b02 = 0.0;
        double b01 = 0.0;
        double b00 = 0.0;
        double a22 = 0.0;
        double a12 = 0.0;
        double a11 = 0.0;
        double a02 = 0.0;
        double a01 = 0.0;
        double a00 = 0.0;
        for (PointMatch m : matches) {
            double[] p = m.getP1().getL();
            double[] q = m.getP2().getW();
            double w = m.getWeight();
            double px = p[0] - pcx;
            double py = p[1] - pcy;
            double pz = p[2] - pcz;
            double qx = q[0] - qcx;
            double qy = q[1] - qcy;
            double qz = q[2] - qcz;
            a00 += w * px * px;
            a01 += w * px * py;
            a02 += w * px * pz;
            a11 += w * py * py;
            a12 += w * py * pz;
            a22 += w * pz * pz;
            b00 += w * px * qx;
            b01 += w * px * qy;
            b02 += w * px * qz;
            b10 += w * py * qx;
            b11 += w * py * qy;
            b12 += w * py * qz;
            b20 += w * pz * qx;
            b21 += w * pz * qy;
            b22 += w * pz * qz;
        }
        double det = a00 * a11 * a22 + a01 * a12 * a02 + a02 * a01 * a12 - a02 * a11 * a02 - a12 * a12 * a00 - a22 * a01 * a01;
        if (det == 0.0) {
            throw new IllDefinedDataPointsException();
        }
        double idet = 1.0 / det;
        double ai00 = (a11 * a22 - a12 * a12) * idet;
        double ai01 = (a02 * a12 - a01 * a22) * idet;
        double ai02 = (a01 * a12 - a02 * a11) * idet;
        double ai11 = (a00 * a22 - a02 * a02) * idet;
        double ai12 = (a02 * a01 - a00 * a12) * idet;
        double ai22 = (a00 * a11 - a01 * a01) * idet;
        this.m00 = ai00 * b00 + ai01 * b10 + ai02 * b20;
        this.m01 = ai01 * b00 + ai11 * b10 + ai12 * b20;
        this.m02 = ai02 * b00 + ai12 * b10 + ai22 * b20;
        this.m10 = ai00 * b01 + ai01 * b11 + ai02 * b21;
        this.m11 = ai01 * b01 + ai11 * b11 + ai12 * b21;
        this.m12 = ai02 * b01 + ai12 * b11 + ai22 * b21;
        this.m20 = ai00 * b02 + ai01 * b12 + ai02 * b22;
        this.m21 = ai01 * b02 + ai11 * b12 + ai12 * b22;
        this.m22 = ai02 * b02 + ai12 * b12 + ai22 * b22;
        this.m03 = qcx - this.m00 * pcx - this.m01 * pcy - this.m02 * pcz;
        this.m13 = qcy - this.m10 * pcx - this.m11 * pcy - this.m12 * pcz;
        this.m23 = qcz - this.m20 * pcx - this.m21 * pcy - this.m22 * pcz;
        this.invert();
    }

    @Override
    public final void set(AffineModel3D m) {
        this.m00 = m.m00;
        this.m10 = m.m10;
        this.m20 = m.m20;
        this.m01 = m.m01;
        this.m11 = m.m11;
        this.m21 = m.m21;
        this.m02 = m.m02;
        this.m12 = m.m12;
        this.m22 = m.m22;
        this.m03 = m.m03;
        this.m13 = m.m13;
        this.m23 = m.m23;
        this.cost = m.cost;
        this.invert();
    }

    @Override
    public AffineModel3D copy() {
        AffineModel3D m = new AffineModel3D();
        m.m00 = this.m00;
        m.m10 = this.m10;
        m.m20 = this.m20;
        m.m01 = this.m01;
        m.m11 = this.m11;
        m.m21 = this.m21;
        m.m02 = this.m02;
        m.m12 = this.m12;
        m.m22 = this.m22;
        m.m03 = this.m03;
        m.m13 = this.m13;
        m.m23 = this.m23;
        m.cost = this.cost;
        m.invert();
        return m;
    }

    protected void invert() {
        double det = Matrix3x3.det(this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22);
        if (det == 0.0) {
            this.isInvertible = false;
            return;
        }
        this.isInvertible = true;
        double idet = 1.0 / det;
        this.i00 = (this.m11 * this.m22 - this.m12 * this.m21) * idet;
        this.i01 = (this.m02 * this.m21 - this.m01 * this.m22) * idet;
        this.i02 = (this.m01 * this.m12 - this.m02 * this.m11) * idet;
        this.i10 = (this.m12 * this.m20 - this.m10 * this.m22) * idet;
        this.i11 = (this.m00 * this.m22 - this.m02 * this.m20) * idet;
        this.i12 = (this.m02 * this.m10 - this.m00 * this.m12) * idet;
        this.i20 = (this.m10 * this.m21 - this.m11 * this.m20) * idet;
        this.i21 = (this.m01 * this.m20 - this.m00 * this.m21) * idet;
        this.i22 = (this.m00 * this.m11 - this.m01 * this.m10) * idet;
        this.i03 = -this.i00 * this.m03 - this.i01 * this.m13 - this.i02 * this.m23;
        this.i13 = -this.i10 * this.m03 - this.i11 * this.m13 - this.i12 * this.m23;
        this.i23 = -this.i20 * this.m03 - this.i21 * this.m13 - this.i22 * this.m23;
    }

    @Override
    public final void preConcatenate(AffineModel3D model) {
        double a00 = model.m00 * this.m00 + model.m01 * this.m10 + model.m02 * this.m20;
        double a01 = model.m00 * this.m01 + model.m01 * this.m11 + model.m02 * this.m21;
        double a02 = model.m00 * this.m02 + model.m01 * this.m12 + model.m02 * this.m22;
        double a03 = model.m00 * this.m03 + model.m01 * this.m13 + model.m02 * this.m23 + model.m03;
        double a10 = model.m10 * this.m00 + model.m11 * this.m10 + model.m12 * this.m20;
        double a11 = model.m10 * this.m01 + model.m11 * this.m11 + model.m12 * this.m21;
        double a12 = model.m10 * this.m02 + model.m11 * this.m12 + model.m12 * this.m22;
        double a13 = model.m10 * this.m03 + model.m11 * this.m13 + model.m12 * this.m23 + model.m13;
        double a20 = model.m20 * this.m00 + model.m21 * this.m10 + model.m22 * this.m20;
        double a21 = model.m20 * this.m01 + model.m21 * this.m11 + model.m22 * this.m21;
        double a22 = model.m20 * this.m02 + model.m21 * this.m12 + model.m22 * this.m22;
        double a23 = model.m20 * this.m03 + model.m21 * this.m13 + model.m22 * this.m23 + model.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(AffineModel3D model) {
        double a00 = this.m00 * model.m00 + this.m01 * model.m10 + this.m02 * model.m20;
        double a01 = this.m00 * model.m01 + this.m01 * model.m11 + this.m02 * model.m21;
        double a02 = this.m00 * model.m02 + this.m01 * model.m12 + this.m02 * model.m22;
        double a03 = this.m00 * model.m03 + this.m01 * model.m13 + this.m02 * model.m23 + this.m03;
        double a10 = this.m10 * model.m00 + this.m11 * model.m10 + this.m12 * model.m20;
        double a11 = this.m10 * model.m01 + this.m11 * model.m11 + this.m12 * model.m21;
        double a12 = this.m10 * model.m02 + this.m11 * model.m12 + this.m12 * model.m22;
        double a13 = this.m10 * model.m03 + this.m11 * model.m13 + this.m12 * model.m23 + this.m13;
        double a20 = this.m20 * model.m00 + this.m21 * model.m10 + this.m22 * model.m20;
        double a21 = this.m20 * model.m01 + this.m21 * model.m11 + this.m22 * model.m21;
        double a22 = this.m20 * model.m02 + this.m21 * model.m12 + this.m22 * model.m22;
        double a23 = this.m20 * model.m03 + this.m21 * model.m13 + this.m22 * model.m23 + this.m23;
        this.m00 = a00;
        this.m01 = a01;
        this.m02 = a02;
        this.m03 = a03;
        this.m10 = a10;
        this.m11 = a11;
        this.m12 = a12;
        this.m13 = a13;
        this.m20 = a20;
        this.m21 = a21;
        this.m22 = a22;
        this.m23 = a23;
        this.invert();
    }

    @Override
    public final void concatenate(TranslationModel3D model) {
        double[] t = model.getTranslation();
        this.m03 = this.m00 * t[0] + this.m01 * t[1] + this.m02 * t[2] + this.m03;
        this.m13 = this.m10 * t[0] + this.m11 * t[1] + this.m12 * t[2] + this.m13;
        this.m23 = this.m20 * t[0] + this.m21 * t[1] + this.m22 * t[2] + this.m23;
        this.invert();
    }

    @Override
    public final void preConcatenate(TranslationModel3D model) {
        double[] t = model.getTranslation();
        this.m03 += t[0];
        this.m13 += t[1];
        this.m23 += t[2];
        this.invert();
    }

    public final void set(double m00, double m01, double m02, double m03, double m10, double m11, double m12, double m13, double m20, double m21, double m22, double m23) {
        this.m00 = m00;
        this.m01 = m01;
        this.m02 = m02;
        this.m03 = m03;
        this.m10 = m10;
        this.m11 = m11;
        this.m12 = m12;
        this.m13 = m13;
        this.m20 = m20;
        this.m21 = m21;
        this.m22 = m22;
        this.m23 = m23;
        this.invert();
    }

    public final String toString() {
        return "3d-affine: (" + this.m00 + ", " + this.m01 + ", " + this.m02 + ", " + this.m03 + ", " + this.m10 + ", " + this.m11 + ", " + this.m12 + ", " + this.m13 + ", " + this.m20 + ", " + this.m21 + ", " + this.m22 + ", " + this.m23 + ")";
    }

    @Override
    public AffineModel3D createInverse() {
        AffineModel3D ict = new AffineModel3D();
        ict.m00 = this.i00;
        ict.m10 = this.i10;
        ict.m20 = this.i20;
        ict.m01 = this.i01;
        ict.m11 = this.i11;
        ict.m21 = this.i21;
        ict.m02 = this.i02;
        ict.m12 = this.i12;
        ict.m22 = this.i22;
        ict.m03 = this.i03;
        ict.m13 = this.i13;
        ict.m23 = this.i23;
        ict.i00 = this.m00;
        ict.i10 = this.m10;
        ict.i20 = this.m20;
        ict.i01 = this.m01;
        ict.i11 = this.m11;
        ict.i21 = this.m21;
        ict.i02 = this.m02;
        ict.i12 = this.m12;
        ict.i22 = this.m22;
        ict.i03 = this.m03;
        ict.i13 = this.m13;
        ict.i23 = this.m23;
        ict.cost = this.cost;
        ict.isInvertible = this.isInvertible;
        return ict;
    }

    public void rotate(int axis, double d) {
        double dcos = Math.cos(d);
        double dsin = Math.sin(d);
        AffineModel3D dR = new AffineModel3D();
        switch (axis) {
            case 0: {
                dR.set(1.0, 0.0, 0.0, 0.0, 0.0, dcos, -dsin, 0.0, 0.0, dsin, dcos, 0.0);
                break;
            }
            case 1: {
                dR.set(dcos, 0.0, dsin, 0.0, 0.0, 1.0, 0.0, 0.0, -dsin, 0.0, dcos, 0.0);
                break;
            }
            default: {
                dR.set(dcos, -dsin, 0.0, 0.0, dsin, dcos, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0);
            }
        }
        this.preConcatenate(dR);
    }

    @Override
    public void toArray(double[] data) {
        data[0] = this.m00;
        data[1] = this.m10;
        data[2] = this.m20;
        data[3] = this.m01;
        data[4] = this.m11;
        data[5] = this.m21;
        data[6] = this.m02;
        data[7] = this.m12;
        data[8] = this.m22;
        data[9] = this.m03;
        data[10] = this.m13;
        data[11] = this.m23;
    }

    @Override
    public void toMatrix(double[][] data) {
        data[0][0] = this.m00;
        data[0][1] = this.m01;
        data[0][2] = this.m02;
        data[0][3] = this.m03;
        data[1][0] = this.m10;
        data[1][1] = this.m11;
        data[1][2] = this.m12;
        data[1][3] = this.m13;
        data[2][0] = this.m20;
        data[2][1] = this.m21;
        data[2][2] = this.m22;
        data[2][3] = this.m23;
    }
}

