/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.teddy.io;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;

public class LFWriter
extends FilterWriter {
    private String lineSeparator = System.getProperty("line.separator");
    private boolean skipLF;

    public LFWriter(Writer out) {
        super(out);
    }

    public String getLineSeparator() {
        return this.lineSeparator;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    @Override
    public void write(int c) throws IOException {
        switch (c) {
            case 13: {
                this.out.write(this.lineSeparator);
                this.skipLF = true;
                break;
            }
            case 10: {
                if (!this.skipLF) {
                    this.out.write(this.lineSeparator);
                }
                this.skipLF = false;
                break;
            }
            default: {
                this.out.write(c);
                this.skipLF = false;
            }
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        int end = off + len;
        block4: for (int i = off; i < end; ++i) {
            switch (cbuf[i]) {
                case '\r': {
                    this.out.write(cbuf, off, i - off);
                    off = i + 1;
                    this.out.write(this.lineSeparator);
                    this.skipLF = true;
                    continue block4;
                }
                case '\n': {
                    this.out.write(cbuf, off, i - off);
                    off = i + 1;
                    if (this.skipLF) {
                        this.skipLF = false;
                        continue block4;
                    }
                    this.out.write(this.lineSeparator);
                    continue block4;
                }
                default: {
                    this.skipLF = false;
                }
            }
        }
        if (off < end) {
            this.out.write(cbuf, off, end - off);
        }
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        this.write(str.toCharArray(), off, len);
    }
}

