/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg;

import java.awt.Color;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.samples.svg.Gradient;

public class LinearGradient
implements Gradient {
    private double x1;
    private double y1;
    private double x2;
    private double y2;
    private boolean isRelativeToFigureBounds = true;
    private double[] stopOffsets;
    private Color[] stopColors;
    private double[] stopOpacities;
    private AffineTransform transform;
    private int spreadMethod;

    public LinearGradient() {
    }

    public LinearGradient(double x1, double y1, double x2, double y2, double[] stopOffsets, Color[] stopColors, double[] stopOpacities, boolean isRelativeToFigureBounds, AffineTransform tx) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.stopOffsets = (double[])stopOffsets.clone();
        this.stopColors = (Color[])stopColors.clone();
        this.stopOpacities = (double[])stopOpacities.clone();
        this.isRelativeToFigureBounds = isRelativeToFigureBounds;
        this.transform = tx;
    }

    public void setGradientVector(double x1, double y1, double x2, double y2) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
    }

    public void setStops(double[] offsets, Color[] colors, double[] stopOpacities) {
        this.stopOffsets = (double[])offsets.clone();
        this.stopColors = (Color[])colors.clone();
        this.stopOpacities = (double[])stopOpacities.clone();
    }

    public void setRelativeToFigureBounds(boolean b) {
        this.isRelativeToFigureBounds = b;
    }

    @Override
    public boolean isRelativeToFigureBounds() {
        return this.isRelativeToFigureBounds;
    }

    public double getX1() {
        return this.x1;
    }

    public double getY1() {
        return this.y1;
    }

    public double getX2() {
        return this.x2;
    }

    public double getY2() {
        return this.y2;
    }

    public double[] getStopOffsets() {
        return (double[])this.stopOffsets.clone();
    }

    public Color[] getStopColors() {
        return (Color[])this.stopColors.clone();
    }

    public double[] getStopOpacities() {
        return (double[])this.stopOpacities.clone();
    }

    public AffineTransform getTransform() {
        return this.transform;
    }

    @Override
    public Paint getPaint(Figure f, double opacity) {
        if (this.stopColors.length == 0) {
            return new Color(0, true);
        }
        Color[] colors = new Color[this.stopColors.length];
        float[] fractions = new float[this.stopColors.length];
        float previousFraction = 0.0f;
        for (int i = 0; i < this.stopColors.length; ++i) {
            fractions[i] = Math.min(1.0f, Math.max(previousFraction, (float)this.stopOffsets[i]));
            colors[i] = new Color(this.stopColors[i].getRGB() & 0xFFFFFF | (int)(opacity * this.stopOpacities[i] * 255.0) << 24, true);
            previousFraction = fractions[i];
        }
        Point2D.Double p1 = new Point2D.Double(this.x1, this.y1);
        Point2D.Double p2 = new Point2D.Double(this.x2, this.y2);
        AffineTransform t = this.transform;
        if (this.isRelativeToFigureBounds) {
            t = (AffineTransform)t.clone();
            Rectangle2D.Double bounds = f.getBounds();
            t.translate(bounds.x, bounds.y);
            t.scale(bounds.width, bounds.height);
        }
        if (this.stopColors.length == 1 || t.getDeterminant() == 0.0) {
            return colors[0];
        }
        LinearGradientPaint gp = new LinearGradientPaint(p1, p2, fractions, colors, MultipleGradientPaint.CycleMethod.NO_CYCLE, MultipleGradientPaint.ColorSpaceType.SRGB, t);
        return gp;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("LinearGradient@");
        buf.append(this.hashCode());
        buf.append('(');
        for (int i = 0; i < this.stopOffsets.length; ++i) {
            if (i != 0) {
                buf.append(',');
            }
            buf.append(this.stopOffsets[i]);
            buf.append('=');
            buf.append(this.stopOpacities[i]);
            buf.append(' ');
            buf.append(Integer.toHexString(this.stopColors[i].getRGB()));
        }
        buf.append(')');
        return buf.toString();
    }

    public void setTransform(AffineTransform tx) {
        this.transform = tx;
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.transform == null) {
            this.transform = (AffineTransform)tx.clone();
        } else {
            this.transform.preConcatenate(tx);
        }
    }

    @Override
    public Object clone() {
        try {
            LinearGradient that = (LinearGradient)super.clone();
            that.stopOffsets = (double[])this.stopOffsets.clone();
            that.stopColors = (Color[])this.stopColors.clone();
            that.stopOpacities = (double[])this.stopOpacities.clone();
            that.transform = (AffineTransform)this.transform.clone();
            return that;
        }
        catch (CloneNotSupportedException ex) {
            InternalError e = new InternalError();
            e.initCause(ex);
            throw e;
        }
    }

    @Override
    public void makeRelativeToFigureBounds(Figure f) {
        if (!this.isRelativeToFigureBounds) {
            this.isRelativeToFigureBounds = true;
            Rectangle2D.Double bounds = f.getBounds();
            this.x1 = (this.x1 - bounds.x) / bounds.width;
            this.y1 = (this.y1 - bounds.y) / bounds.height;
            this.x2 = (this.x2 - bounds.x) / bounds.width;
            this.y2 = (this.y2 - bounds.y) / bounds.height;
        }
    }

    public int hashCode() {
        long bits = Double.doubleToLongBits(this.x1);
        bits += Double.doubleToLongBits(this.y1) * 31L;
        bits += Double.doubleToLongBits(this.x2) * 35L;
        bits += Double.doubleToLongBits(this.y2) * 39L;
        bits += (long)(this.stopColors[0].hashCode() * 43);
        return (int)(bits += (long)(this.stopColors[this.stopColors.length - 1].hashCode() * 47)) ^ (int)(bits >> 32);
    }

    public boolean equals(Object o) {
        if (o instanceof LinearGradient) {
            return this.equals((LinearGradient)o);
        }
        return false;
    }

    public boolean equals(LinearGradient that) {
        return this.x1 == that.x1 && this.y1 == that.y1 && this.x2 == that.x2 && this.y2 == that.y2 && this.isRelativeToFigureBounds == that.isRelativeToFigureBounds && Arrays.equals(this.stopOffsets, that.stopOffsets) && Arrays.equals(this.stopOpacities, that.stopOpacities) && Arrays.equals(this.stopColors, that.stopColors) && this.transform.equals(that.transform);
    }
}

